/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.framework;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.testing.framework.TestingFramework;
import org.apache.hc.core5.testing.framework.TestingFrameworkException;

public class TestingFrameworkRequestHandler
implements HttpRequestHandler {
    protected Throwable thrown;
    protected Map<String, Object> requestExpectations;
    protected Map<String, Object> desiredResponse;

    public void setRequestExpectations(Map<String, Object> requestExpectations) throws TestingFrameworkException {
        this.requestExpectations = (Map)TestingFramework.deepcopy(requestExpectations);
    }

    public void setDesiredResponse(Map<String, Object> desiredResponse) throws TestingFrameworkException {
        this.desiredResponse = (Map)TestingFramework.deepcopy(desiredResponse);
    }

    public void assertNothingThrown() throws TestingFrameworkException {
        if (this.thrown != null) {
            TestingFrameworkException e = this.thrown instanceof TestingFrameworkException ? (TestingFrameworkException)this.thrown : new TestingFrameworkException(this.thrown);
            this.thrown = null;
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handle(ClassicHttpRequest request, ClassicHttpResponse response, HttpContext context) throws HttpException, IOException {
        try {
            Map desiredHeaders;
            ProtocolVersion expectedProtocolVersion;
            ProtocolVersion protocolVersion;
            String string;
            HttpEntity entity;
            String contentType;
            HttpEntity entity2;
            String data;
            String expectedBody;
            Map expectedHeaders;
            Map expectedQuery;
            String actualMethod = request.getMethod();
            String expectedMethod = (String)this.requestExpectations.get("method");
            if (!actualMethod.equals(expectedMethod)) {
                throw new TestingFrameworkException("Method not expected.  expected=" + expectedMethod + "; actual=" + actualMethod);
            }
            Object desiredStatus = this.desiredResponse.get("status");
            if (desiredStatus != null) {
                response.setCode(((Integer)desiredStatus).intValue());
            }
            if ((expectedQuery = (Map)this.requestExpectations.get("query")) != null) {
                URI uri = request.getUri();
                URIBuilder uriBuilder = new URIBuilder(uri, StandardCharsets.UTF_8);
                List actualParams = uriBuilder.getQueryParams();
                HashMap<String, String> actualParamsMap = new HashMap<String, String>();
                for (NameValuePair nameValuePair : actualParams) {
                    actualParamsMap.put(nameValuePair.getName(), nameValuePair.getValue());
                }
                for (Map.Entry entry : expectedQuery.entrySet()) {
                    String expectedParamValue;
                    String key = (String)entry.getKey();
                    if (!actualParamsMap.containsKey(key)) {
                        throw new TestingFrameworkException("Expected parameter not found: " + key);
                    }
                    String actualParamValue = (String)actualParamsMap.get(key);
                    if (actualParamValue.equals(expectedParamValue = (String)entry.getValue())) continue;
                    throw new TestingFrameworkException("Expected parameter value not found.  Parameter=" + key + "; expected=" + expectedParamValue + "; actual=" + actualParamValue);
                }
            }
            if ((expectedHeaders = (Map)this.requestExpectations.get("headers")) != null) {
                void var13_24;
                Header[] actualHeaders;
                HashMap<String, String> actualHeadersMap = new HashMap<String, String>();
                Header[] arr$ = actualHeaders = request.getHeaders();
                int len$ = arr$.length;
                boolean bl = false;
                while (var13_24 < len$) {
                    Header header = arr$[var13_24];
                    actualHeadersMap.put(header.getName(), header.getValue());
                    ++var13_24;
                }
                for (Map.Entry expectedHeader : expectedHeaders.entrySet()) {
                    String expectedHeaderValue;
                    String string2 = (String)expectedHeader.getKey();
                    if (!actualHeadersMap.containsKey(string2)) {
                        throw new TestingFrameworkException("Expected header not found: " + string2);
                    }
                    String actualHeaderValue = (String)actualHeadersMap.get(string2);
                    if (actualHeaderValue.equals(expectedHeaderValue = (String)expectedHeader.getValue())) continue;
                    throw new TestingFrameworkException("Expected header value not found.  Name=" + string2 + "; expected=" + expectedHeaderValue + "; actual=" + actualHeaderValue);
                }
            }
            if ((expectedBody = (String)this.requestExpectations.get("body")) != null && !(data = EntityUtils.toString((HttpEntity)(entity2 = request.getEntity()))).equals(expectedBody)) {
                throw new TestingFrameworkException("Expected body not found.  Body=" + data + "; expected=" + expectedBody);
            }
            String requestContentType = (String)this.requestExpectations.get("contentType");
            if (requestContentType != null && !(contentType = (entity = request.getEntity()).getContentType()).equals(string = (String)this.requestExpectations.get("contentType"))) {
                throw new TestingFrameworkException("Expected request content type not found.  Content Type=" + contentType + "; expected=" + string);
            }
            if (this.requestExpectations.containsKey("protocolVersion") && !(protocolVersion = request.getVersion()).equals((Object)(expectedProtocolVersion = (ProtocolVersion)this.requestExpectations.get("protocolVersion")))) {
                throw new TestingFrameworkException("Expected request protocol version not found.  Protocol Version=" + protocolVersion + "; expected=" + expectedProtocolVersion);
            }
            String desiredBody = (String)this.desiredResponse.get("body");
            if (desiredBody != null) {
                String desiredContentType = (String)this.desiredResponse.get("contentType");
                StringEntity stringEntity = desiredContentType != null ? new StringEntity(desiredBody, ContentType.parse((CharSequence)desiredContentType)) : new StringEntity(desiredBody);
                response.setEntity((HttpEntity)stringEntity);
            }
            if ((desiredHeaders = (Map)this.desiredResponse.get("headers")) != null) {
                for (Map.Entry entry : desiredHeaders.entrySet()) {
                    response.setHeader((String)entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Throwable t) {
            this.thrown = t;
        }
    }
}

