/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite3.catalog.ColumnSorted;
import org.apache.ignite3.catalog.IndexType;
import org.apache.ignite3.internal.catalog.sql.IndexColumnImpl;
import org.apache.ignite3.internal.catalog.sql.QueryContext;
import org.apache.ignite3.internal.catalog.sql.QueryPart;
import org.apache.ignite3.internal.catalog.sql.QueryPartCollection;

class Constraint
extends QueryPart {
    private IndexType pkType;
    private final List<IndexColumnImpl> pkColumns = new ArrayList<IndexColumnImpl>();

    Constraint() {
    }

    Constraint primaryKey(ColumnSorted ... columns) {
        return this.primaryKey(IndexType.DEFAULT, Arrays.asList(columns));
    }

    Constraint primaryKey(IndexType type, List<ColumnSorted> columns) {
        this.pkType = type;
        for (ColumnSorted column : columns) {
            this.pkColumns.add(IndexColumnImpl.wrap(column));
        }
        return this;
    }

    @Override
    protected void accept(QueryContext ctx) {
        if (!this.pkColumns.isEmpty()) {
            ctx.sql("PRIMARY KEY");
            if (this.pkType != null && this.pkType != IndexType.DEFAULT) {
                ctx.sql(" USING ").sql(this.pkType.name());
            }
            ctx.sql(" (");
            ctx.visit(QueryPartCollection.partsList(this.pkColumns));
            ctx.sql(")");
        }
    }
}

