/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.exceptions;

import org.apache.ignite3.internal.metastorage.exceptions.MetaStorageException;
import org.apache.ignite3.lang.ErrorGroups;

public class CompactedException
extends MetaStorageException {
    private static final long serialVersionUID = -6849399873850280288L;

    public CompactedException() {
        super(ErrorGroups.MetaStorage.COMPACTED_ERR);
    }

    public CompactedException(long requestedRevision, long latestCompactedRevision) {
        super(ErrorGroups.MetaStorage.COMPACTED_ERR, String.format("Requested revision has already been compacted: [requested=%s, lastCompacted=%s]", requestedRevision, latestCompactedRevision));
    }

    public CompactedException(String message) {
        super(ErrorGroups.MetaStorage.COMPACTED_ERR, message);
    }

    public CompactedException(String message, Throwable cause) {
        super(ErrorGroups.MetaStorage.COMPACTED_ERR, message, cause);
    }

    public CompactedException(Throwable cause) {
        super(ErrorGroups.MetaStorage.COMPACTED_ERR, cause);
    }

    public static void throwIfRequestedRevisionLessThanOrEqualToCompacted(long requestedRevision, long compactedRevision) {
        if (requestedRevision <= compactedRevision) {
            throw new CompactedException(requestedRevision, compactedRevision);
        }
    }
}

