/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rel;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.SqlKind;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite3.internal.sql.engine.rel.explain.IgniteRelWriter;

public class IgniteKeyValueModify
extends AbstractRelNode
implements IgniteRel {
    private static final String REL_TYPE_NAME = "KeyValueModify";
    private final RelOptTable table;
    private final Operation operation;
    private final List<RexNode> expressions;

    public IgniteKeyValueModify(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, Operation operation, List<RexNode> expressions) {
        super(cluster, traits);
        this.table = table;
        this.operation = operation;
        this.expressions = expressions;
    }

    public Operation operation() {
        return this.operation;
    }

    public RelDataType deriveRowType() {
        return RelOptUtil.createDmlRowType((SqlKind)this.operation.kind, (RelDataTypeFactory)this.getCluster().getTypeFactory());
    }

    public RelOptTable getTable() {
        return this.table;
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public RelNode accept(RexShuttle shuttle) {
        List expressions0 = shuttle.apply(this.expressions);
        if (expressions0 == this.expressions) {
            return this;
        }
        return new IgniteKeyValueModify(this.getCluster(), this.getTraitSet(), this.table, this.operation, expressions0);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        assert (inputs.isEmpty()) : inputs;
        return new IgniteKeyValueModify(cluster, this.getTraitSet(), this.table, this.operation, this.expressions);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("table", (Object)this.table.getQualifiedName()).item("operation", (Object)this.operation).item("expressions", this.expressions);
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }

    public List<RexNode> expressions() {
        return this.expressions;
    }

    @Override
    public IgniteRelWriter explain(IgniteRelWriter writer) {
        if (this.operation == Operation.DELETE) {
            writer.addKeyExpression(this.expressions);
        } else {
            assert (this.operation == Operation.INSERT) : this.operation;
            writer.addSourceExpressions(this.expressions);
        }
        return writer.addTable(this.table).addModifyOperationType(this.operation.op);
    }

    public static enum Operation {
        INSERT(SqlKind.INSERT, TableModify.Operation.INSERT),
        DELETE(SqlKind.DELETE, TableModify.Operation.DELETE);

        private final SqlKind kind;
        private final TableModify.Operation op;

        private Operation(SqlKind kind, TableModify.Operation op) {
            this.kind = kind;
            this.op = op;
        }
    }
}

