/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.raft.jraft.util.NonReentrantLock;
import org.apache.ignite3.raft.jraft.util.ThreadHelper;

public class ThreadId {
    private static final IgniteLogger LOG = Loggers.forClass(ThreadId.class);
    private static final int TRY_LOCK_TIMEOUT_MS = 10;
    private final Object data;
    private final NonReentrantLock lock = new NonReentrantLock();
    private final List<Integer> pendingErrors = new ArrayList<Integer>();
    private final OnError onError;
    private volatile boolean destroyed;

    public ThreadId(Object data, OnError onError) {
        this.data = data;
        this.onError = onError;
        this.destroyed = false;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public Object getData() {
        return this.data;
    }

    public Object lock() {
        if (this.destroyed) {
            return null;
        }
        try {
            while (!this.lock.tryLock(10L, TimeUnit.MILLISECONDS)) {
                if (!this.destroyed) continue;
                return null;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        if (this.destroyed) {
            this.lock.unlock();
            return null;
        }
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        if (!this.lock.isHeldByCurrentThread()) {
            LOG.warn("Fail to unlock with {}, the lock is held by {} and current thread is {}.", this.data, this.lock.getOwner(), Thread.currentThread());
            return;
        }
        boolean doUnlock = true;
        try {
            ArrayList<Integer> errors;
            List<Integer> list = this.pendingErrors;
            synchronized (list) {
                errors = new ArrayList<Integer>(this.pendingErrors);
                this.pendingErrors.clear();
            }
            for (Integer code : errors) {
                doUnlock = false;
                if (this.onError == null) continue;
                this.onError.onError(this, this.data, code);
            }
        }
        finally {
            if (doUnlock) {
                this.lock.unlock();
            }
        }
    }

    public void join() {
        while (!this.destroyed) {
            ThreadHelper.onSpinWait();
        }
    }

    public String toString() {
        return this.data.toString();
    }

    public void unlockAndDestroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        if (!this.lock.isHeldByCurrentThread()) {
            LOG.warn("Fail to unlockAndDestroy with {}, the lock is held by {} and current thread is {}.", this.data, this.lock.getOwner(), Thread.currentThread());
            return;
        }
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setError(int errorCode) {
        if (this.destroyed) {
            return;
        }
        List<Integer> list = this.pendingErrors;
        synchronized (list) {
            if (this.lock.tryLock()) {
                if (this.destroyed) {
                    this.lock.unlock();
                    return;
                }
                if (this.onError != null) {
                    this.onError.onError(this, this.data, errorCode);
                }
            } else {
                this.pendingErrors.add(errorCode);
            }
        }
    }

    public static interface OnError {
        public void onError(ThreadId var1, Object var2, int var3);
    }
}

