/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.snapshot;

import java.util.Arrays;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.management.snapshot.SnapshotJob;
import org.apache.ignite.internal.management.snapshot.SnapshotRestoreCommandArg;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;

@GridInternal
public class SnapshotRestoreTask
extends VisorOneNodeTask<SnapshotRestoreCommandArg, String> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<SnapshotRestoreCommandArg, String> job(SnapshotRestoreCommandArg arg) {
        if (arg.cancel()) {
            return new SnapshotRestoreCancelJob(arg, this.debug);
        }
        if (arg.status()) {
            return new SnapshotRestoreStatusJob(arg, this.debug);
        }
        return new SnapshotStartRestoreJob(arg, this.debug);
    }

    @Deprecated
    private static class SnapshotRestoreStatusJob
    extends SnapshotJob<SnapshotRestoreCommandArg, String> {
        private static final long serialVersionUID = 0L;

        protected SnapshotRestoreStatusJob(SnapshotRestoreCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected String run(SnapshotRestoreCommandArg arg) throws IgniteException {
            boolean state = this.ignite.context().cache().context().snapshotMgr().restoreStatus(arg.snapshotName()).get();
            return "Snapshot cache group restore operation is " + (state ? "" : "NOT ") + "running [snapshot=" + arg.snapshotName() + "]";
        }
    }

    @Deprecated
    private static class SnapshotRestoreCancelJob
    extends SnapshotJob<SnapshotRestoreCommandArg, String> {
        private static final long serialVersionUID = 0L;

        protected SnapshotRestoreCancelJob(SnapshotRestoreCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected String run(SnapshotRestoreCommandArg arg) throws IgniteException {
            boolean stopped = this.ignite.snapshot().cancelSnapshotRestore(arg.snapshotName()).get();
            return "Snapshot cache group restore operation " + (stopped ? "canceled" : "is NOT running") + " [snapshot=" + arg.snapshotName() + "]";
        }
    }

    private static class SnapshotStartRestoreJob
    extends SnapshotJob<SnapshotRestoreCommandArg, String> {
        private static final long serialVersionUID = 0L;

        protected SnapshotStartRestoreJob(SnapshotRestoreCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected String run(SnapshotRestoreCommandArg arg) throws IgniteException {
            IgniteSnapshotManager.ClusterSnapshotFuture snpFut;
            IgniteFutureImpl<Void> fut = this.ignite.context().cache().context().snapshotMgr().restoreSnapshot(arg.snapshotName(), arg.src(), arg.groups() == null ? null : Arrays.asList(arg.groups()), arg.increment(), arg.check());
            IgniteSnapshotManager.ClusterSnapshotFuture clusterSnapshotFuture = snpFut = fut.internalFuture() instanceof IgniteSnapshotManager.ClusterSnapshotFuture ? (IgniteSnapshotManager.ClusterSnapshotFuture)fut.internalFuture() : null;
            if (arg.sync() || fut.isDone()) {
                fut.get();
            }
            String msgSuff = arg.sync() ? "completed successfully" : "started";
            String msgGrps = arg.groups() == null ? "" : ", group(s)=" + String.join((CharSequence)",", arg.groups());
            String msgId = snpFut != null && snpFut.requestId() != null ? ", id=" + snpFut.requestId() : "";
            return "Snapshot cache group restore operation " + msgSuff + " [name=" + arg.snapshotName() + msgGrps + msgId + "]";
        }
    }
}

