/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.thread;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.worker.GridWorker;

public class IgniteThread
extends Thread {
    public static final int GRP_IDX_UNASSIGNED = -1;
    private static final AtomicLong cntr = new AtomicLong();
    protected final String igniteInstanceName;
    private int compositeRwLockIdx;
    private final int stripe;
    private final byte plc;
    private boolean holdsTopLock;
    private boolean forbiddenToRequestBinaryMetadata;

    public IgniteThread(GridWorker worker) {
        this(worker.igniteInstanceName(), worker.name(), worker, -1, -1, -1);
    }

    public IgniteThread(String igniteInstanceName, String threadName) {
        this(igniteInstanceName, threadName, null);
    }

    public IgniteThread(String igniteInstanceName, String threadName, Runnable r) {
        this(igniteInstanceName, threadName, r, -1, -1, -1);
    }

    public IgniteThread(String igniteInstanceName, String threadName, Runnable r, int grpIdx, int stripe, byte plc) {
        super(r, IgniteThread.createName(cntr.incrementAndGet(), threadName, igniteInstanceName));
        A.ensure(grpIdx >= -1, "grpIdx >= -1");
        this.igniteInstanceName = igniteInstanceName;
        this.compositeRwLockIdx = grpIdx;
        this.stripe = stripe;
        this.plc = plc;
    }

    protected IgniteThread(String igniteInstanceName, ThreadGroup threadGrp, String threadName) {
        super(threadGrp, threadName);
        this.igniteInstanceName = igniteInstanceName;
        this.compositeRwLockIdx = -1;
        this.stripe = -1;
        this.plc = (byte)-1;
    }

    public byte policy() {
        return this.plc;
    }

    public int stripe() {
        return this.stripe;
    }

    public boolean cachePoolThread() {
        return this.stripe >= 0 || this.plc == 2 || this.plc == 5;
    }

    public String getIgniteInstanceName() {
        return this.igniteInstanceName;
    }

    public int compositeRwLockIndex() {
        return this.compositeRwLockIdx;
    }

    public void compositeRwLockIndex(int compositeRwLockIdx) {
        this.compositeRwLockIdx = compositeRwLockIdx;
    }

    public boolean isForbiddenToRequestBinaryMetadata() {
        return this.holdsTopLock || this.forbiddenToRequestBinaryMetadata;
    }

    public static boolean currentThreadCanRequestBinaryMetadata() {
        IgniteThread curThread = IgniteThread.current();
        return curThread == null || !curThread.isForbiddenToRequestBinaryMetadata();
    }

    public static void onEntryProcessorEntered(boolean holdsTopLock) {
        Thread curThread = Thread.currentThread();
        if (curThread instanceof IgniteThread) {
            ((IgniteThread)curThread).holdsTopLock = holdsTopLock;
        }
    }

    public static void onEntryProcessorLeft() {
        Thread curThread = Thread.currentThread();
        if (curThread instanceof IgniteThread) {
            ((IgniteThread)curThread).holdsTopLock = false;
        }
    }

    public static void onForbidBinaryMetadataRequestSectionEntered() {
        Thread curThread = Thread.currentThread();
        if (curThread instanceof IgniteThread) {
            ((IgniteThread)curThread).forbiddenToRequestBinaryMetadata = true;
        }
    }

    public static void onForbidBinaryMetadataRequestSectionLeft() {
        Thread curThread = Thread.currentThread();
        if (curThread instanceof IgniteThread) {
            ((IgniteThread)curThread).forbiddenToRequestBinaryMetadata = false;
        }
    }

    public static IgniteThread current() {
        Thread thread = Thread.currentThread();
        return thread.getClass() == IgniteThread.class || thread instanceof IgniteThread ? (IgniteThread)thread : null;
    }

    protected static String createName(long num, String threadName, String igniteInstanceName) {
        return threadName + "-#" + num + (String)(igniteInstanceName != null ? "%" + igniteInstanceName + "%" : "");
    }

    @Override
    public String toString() {
        return S.toString(IgniteThread.class, this, "name", (Object)this.getName());
    }
}

