/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.reader;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.AlignedSeriesScanUtil;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.reader.IDataBlockReader;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.read.common.block.TsBlock;

public class SeriesDataBlockReader
implements IDataBlockReader {
    private final SeriesScanUtil seriesScanUtil;
    private TsBlock tsBlock;
    private boolean hasCachedBatchData = false;

    public SeriesDataBlockReader(PartialPath seriesPath, Set<String> allSensors, FragmentInstanceContext context, QueryDataSource dataSource, boolean ascending) {
        SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
        scanOptionsBuilder.withAllSensors(allSensors);
        if (seriesPath instanceof AlignedPath) {
            this.seriesScanUtil = new AlignedSeriesScanUtil(seriesPath, ascending ? Ordering.ASC : Ordering.DESC, scanOptionsBuilder.build(), context);
        } else if (seriesPath instanceof MeasurementPath) {
            this.seriesScanUtil = new SeriesScanUtil(seriesPath, ascending ? Ordering.ASC : Ordering.DESC, scanOptionsBuilder.build(), context);
        } else {
            throw new IllegalArgumentException("Should call exact sub class!");
        }
        this.seriesScanUtil.initQueryDataSource(dataSource);
    }

    public SeriesDataBlockReader(PartialPath seriesPath, FragmentInstanceContext context, List<TsFileResource> seqFileResource, List<TsFileResource> unseqFileResource, boolean ascending) {
        SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
        if (seriesPath instanceof AlignedPath) {
            scanOptionsBuilder.withAllSensors(new HashSet<String>(((AlignedPath)seriesPath).getMeasurementList()));
            this.seriesScanUtil = new AlignedSeriesScanUtil(seriesPath, ascending ? Ordering.ASC : Ordering.DESC, scanOptionsBuilder.build(), context);
        } else {
            scanOptionsBuilder.withAllSensors(Sets.newHashSet((Object[])new String[]{seriesPath.getMeasurement()}));
            this.seriesScanUtil = new SeriesScanUtil(seriesPath, ascending ? Ordering.ASC : Ordering.DESC, scanOptionsBuilder.build(), context);
        }
        QueryDataSource queryDataSource = new QueryDataSource(seqFileResource, unseqFileResource);
        this.seriesScanUtil.initQueryDataSource(queryDataSource);
    }

    @Override
    public boolean hasNextBatch() throws IOException {
        if (this.hasCachedBatchData) {
            return true;
        }
        if (this.readPageData()) {
            this.hasCachedBatchData = true;
            return true;
        }
        if (this.readChunkData()) {
            this.hasCachedBatchData = true;
            return true;
        }
        while (this.seriesScanUtil.hasNextFile()) {
            if (!this.readChunkData()) continue;
            this.hasCachedBatchData = true;
            return true;
        }
        return this.hasCachedBatchData;
    }

    @Override
    public TsBlock nextBatch() throws IOException {
        if (this.hasCachedBatchData || this.hasNextBatch()) {
            this.hasCachedBatchData = false;
            return this.tsBlock;
        }
        throw new IOException("no next block");
    }

    @Override
    public void close() throws IOException {
    }

    private boolean readChunkData() throws IOException {
        while (this.seriesScanUtil.hasNextChunk()) {
            if (!this.readPageData()) continue;
            return true;
        }
        return false;
    }

    private boolean readPageData() throws IOException {
        while (this.seriesScanUtil.hasNextPage()) {
            this.tsBlock = this.seriesScanUtil.nextPage();
            if (this.isEmpty(this.tsBlock)) continue;
            return true;
        }
        return false;
    }

    private boolean isEmpty(TsBlock tsBlock) {
        return tsBlock == null || tsBlock.isEmpty();
    }
}

