/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class SamplingIntervalDiagnosticsDataType
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=856");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=857");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=858");
    private final Double samplingInterval;
    private final UInteger monitoredItemCount;
    private final UInteger maxMonitoredItemCount;
    private final UInteger disabledMonitoredItemCount;

    public SamplingIntervalDiagnosticsDataType(Double samplingInterval, UInteger monitoredItemCount, UInteger maxMonitoredItemCount, UInteger disabledMonitoredItemCount) {
        this.samplingInterval = samplingInterval;
        this.monitoredItemCount = monitoredItemCount;
        this.maxMonitoredItemCount = maxMonitoredItemCount;
        this.disabledMonitoredItemCount = disabledMonitoredItemCount;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public Double getSamplingInterval() {
        return this.samplingInterval;
    }

    public UInteger getMonitoredItemCount() {
        return this.monitoredItemCount;
    }

    public UInteger getMaxMonitoredItemCount() {
        return this.maxMonitoredItemCount;
    }

    public UInteger getDisabledMonitoredItemCount() {
        return this.disabledMonitoredItemCount;
    }

    protected SamplingIntervalDiagnosticsDataType(SamplingIntervalDiagnosticsDataTypeBuilder<?, ?> b) {
        super(b);
        this.samplingInterval = ((SamplingIntervalDiagnosticsDataTypeBuilder)b).samplingInterval;
        this.monitoredItemCount = ((SamplingIntervalDiagnosticsDataTypeBuilder)b).monitoredItemCount;
        this.maxMonitoredItemCount = ((SamplingIntervalDiagnosticsDataTypeBuilder)b).maxMonitoredItemCount;
        this.disabledMonitoredItemCount = ((SamplingIntervalDiagnosticsDataTypeBuilder)b).disabledMonitoredItemCount;
    }

    public static SamplingIntervalDiagnosticsDataTypeBuilder<?, ?> builder() {
        return new SamplingIntervalDiagnosticsDataTypeBuilderImpl();
    }

    public SamplingIntervalDiagnosticsDataTypeBuilder<?, ?> toBuilder() {
        return new SamplingIntervalDiagnosticsDataTypeBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SamplingIntervalDiagnosticsDataType)) {
            return false;
        }
        SamplingIntervalDiagnosticsDataType other = (SamplingIntervalDiagnosticsDataType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$samplingInterval = this.getSamplingInterval();
        Double other$samplingInterval = other.getSamplingInterval();
        if (this$samplingInterval == null ? other$samplingInterval != null : !((Object)this$samplingInterval).equals(other$samplingInterval)) {
            return false;
        }
        UInteger this$monitoredItemCount = this.getMonitoredItemCount();
        UInteger other$monitoredItemCount = other.getMonitoredItemCount();
        if (this$monitoredItemCount == null ? other$monitoredItemCount != null : !((Object)this$monitoredItemCount).equals(other$monitoredItemCount)) {
            return false;
        }
        UInteger this$maxMonitoredItemCount = this.getMaxMonitoredItemCount();
        UInteger other$maxMonitoredItemCount = other.getMaxMonitoredItemCount();
        if (this$maxMonitoredItemCount == null ? other$maxMonitoredItemCount != null : !((Object)this$maxMonitoredItemCount).equals(other$maxMonitoredItemCount)) {
            return false;
        }
        UInteger this$disabledMonitoredItemCount = this.getDisabledMonitoredItemCount();
        UInteger other$disabledMonitoredItemCount = other.getDisabledMonitoredItemCount();
        return !(this$disabledMonitoredItemCount == null ? other$disabledMonitoredItemCount != null : !((Object)this$disabledMonitoredItemCount).equals(other$disabledMonitoredItemCount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SamplingIntervalDiagnosticsDataType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $samplingInterval = this.getSamplingInterval();
        result = result * 59 + ($samplingInterval == null ? 43 : ((Object)$samplingInterval).hashCode());
        UInteger $monitoredItemCount = this.getMonitoredItemCount();
        result = result * 59 + ($monitoredItemCount == null ? 43 : ((Object)$monitoredItemCount).hashCode());
        UInteger $maxMonitoredItemCount = this.getMaxMonitoredItemCount();
        result = result * 59 + ($maxMonitoredItemCount == null ? 43 : ((Object)$maxMonitoredItemCount).hashCode());
        UInteger $disabledMonitoredItemCount = this.getDisabledMonitoredItemCount();
        result = result * 59 + ($disabledMonitoredItemCount == null ? 43 : ((Object)$disabledMonitoredItemCount).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SamplingIntervalDiagnosticsDataType(samplingInterval=" + this.getSamplingInterval() + ", monitoredItemCount=" + this.getMonitoredItemCount() + ", maxMonitoredItemCount=" + this.getMaxMonitoredItemCount() + ", disabledMonitoredItemCount=" + this.getDisabledMonitoredItemCount() + ")";
    }

    private static final class SamplingIntervalDiagnosticsDataTypeBuilderImpl
    extends SamplingIntervalDiagnosticsDataTypeBuilder<SamplingIntervalDiagnosticsDataType, SamplingIntervalDiagnosticsDataTypeBuilderImpl> {
        private SamplingIntervalDiagnosticsDataTypeBuilderImpl() {
        }

        @Override
        protected SamplingIntervalDiagnosticsDataTypeBuilderImpl self() {
            return this;
        }

        @Override
        public SamplingIntervalDiagnosticsDataType build() {
            return new SamplingIntervalDiagnosticsDataType(this);
        }
    }

    public static abstract class SamplingIntervalDiagnosticsDataTypeBuilder<C extends SamplingIntervalDiagnosticsDataType, B extends SamplingIntervalDiagnosticsDataTypeBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private Double samplingInterval;
        private UInteger monitoredItemCount;
        private UInteger maxMonitoredItemCount;
        private UInteger disabledMonitoredItemCount;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SamplingIntervalDiagnosticsDataTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(SamplingIntervalDiagnosticsDataType instance, SamplingIntervalDiagnosticsDataTypeBuilder<?, ?> b) {
            b.samplingInterval(instance.samplingInterval);
            b.monitoredItemCount(instance.monitoredItemCount);
            b.maxMonitoredItemCount(instance.maxMonitoredItemCount);
            b.disabledMonitoredItemCount(instance.disabledMonitoredItemCount);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B samplingInterval(Double samplingInterval) {
            this.samplingInterval = samplingInterval;
            return (B)this.self();
        }

        public B monitoredItemCount(UInteger monitoredItemCount) {
            this.monitoredItemCount = monitoredItemCount;
            return (B)this.self();
        }

        public B maxMonitoredItemCount(UInteger maxMonitoredItemCount) {
            this.maxMonitoredItemCount = maxMonitoredItemCount;
            return (B)this.self();
        }

        public B disabledMonitoredItemCount(UInteger disabledMonitoredItemCount) {
            this.disabledMonitoredItemCount = disabledMonitoredItemCount;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SamplingIntervalDiagnosticsDataType.SamplingIntervalDiagnosticsDataTypeBuilder(super=" + super.toString() + ", samplingInterval=" + this.samplingInterval + ", monitoredItemCount=" + this.monitoredItemCount + ", maxMonitoredItemCount=" + this.maxMonitoredItemCount + ", disabledMonitoredItemCount=" + this.disabledMonitoredItemCount + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<SamplingIntervalDiagnosticsDataType> {
        @Override
        public Class<SamplingIntervalDiagnosticsDataType> getType() {
            return SamplingIntervalDiagnosticsDataType.class;
        }

        @Override
        public SamplingIntervalDiagnosticsDataType decode(SerializationContext context, UaDecoder decoder) {
            Double samplingInterval = decoder.readDouble("SamplingInterval");
            UInteger monitoredItemCount = decoder.readUInt32("MonitoredItemCount");
            UInteger maxMonitoredItemCount = decoder.readUInt32("MaxMonitoredItemCount");
            UInteger disabledMonitoredItemCount = decoder.readUInt32("DisabledMonitoredItemCount");
            return new SamplingIntervalDiagnosticsDataType(samplingInterval, monitoredItemCount, maxMonitoredItemCount, disabledMonitoredItemCount);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, SamplingIntervalDiagnosticsDataType value) {
            encoder.writeDouble("SamplingInterval", value.getSamplingInterval());
            encoder.writeUInt32("MonitoredItemCount", value.getMonitoredItemCount());
            encoder.writeUInt32("MaxMonitoredItemCount", value.getMaxMonitoredItemCount());
            encoder.writeUInt32("DisabledMonitoredItemCount", value.getDisabledMonitoredItemCount());
        }
    }
}

