/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.config;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class ConsumerConfig
extends PipeParameters {
    public ConsumerConfig() {
        super(Collections.emptyMap());
    }

    public ConsumerConfig(Map<String, String> attributes) {
        super(attributes);
    }

    public static ByteBuffer serialize(ConsumerConfig consumerConfig) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            ByteBuffer byteBuffer;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                consumerConfig.serialize(outputStream);
                byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            }
            return byteBuffer;
        }
    }

    private void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((Map)this.attributes, (OutputStream)stream);
    }

    public static ConsumerConfig deserialize(ByteBuffer buffer) {
        return new ConsumerConfig(ReadWriteIOUtils.readMap((ByteBuffer)buffer));
    }

    public String getConsumerId() {
        return this.getString("consumer-id");
    }

    public String getConsumerGroupId() {
        return this.getString("group-id");
    }

    public String getUsername() {
        return this.getString("username");
    }

    public String getPassword() {
        return this.getString("password");
    }

    public String getSqlDialect() {
        return this.getString("sql-dialect");
    }

    public void setConsumerId(String consumerId) {
        this.attributes.put("consumer-id", consumerId);
    }

    public void setConsumerGroupId(String consumerGroupId) {
        this.attributes.put("group-id", consumerGroupId);
    }
}

