/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.partition.executor.hash;

import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.commons.partition.executor.SeriesPartitionExecutor;
import org.apache.tsfile.file.metadata.IDeviceID;

public class APHashExecutor
extends SeriesPartitionExecutor {
    public APHashExecutor(int deviceGroupCount) {
        super(deviceGroupCount);
    }

    @Override
    public TSeriesPartitionSlot getSeriesPartitionSlot(String device) {
        int hash = 0;
        for (int i = 0; i < device.length(); ++i) {
            if ((i & 1) == 0) {
                hash ^= hash << 7 ^ device.charAt(i) ^ hash >> 3;
                continue;
            }
            hash ^= ~(hash << 11 ^ device.charAt(i) ^ hash >> 5);
        }
        return new TSeriesPartitionSlot((hash &= Integer.MAX_VALUE) % this.seriesPartitionSlotNum);
    }

    @Override
    public TSeriesPartitionSlot getSeriesPartitionSlot(IDeviceID deviceID) {
        int hash = 0;
        int segmentNum = deviceID.segmentNum();
        int index = 0;
        for (int segmentID = 0; segmentID < segmentNum; ++segmentID) {
            Object segment = deviceID.segment(segmentID);
            if (segment instanceof String) {
                String segmentStr = (String)segment;
                for (int i = 0; i < segmentStr.length(); ++i) {
                    if ((index++ & 1) == 0) {
                        hash ^= hash << 7 ^ segmentStr.charAt(i) ^ hash >> 3;
                        continue;
                    }
                    hash ^= ~(hash << 11 ^ segmentStr.charAt(i) ^ hash >> 5);
                }
            } else {
                hash = (index++ & 1) == 0 ? (hash ^= hash << 7 ^ 0x10000 ^ hash >> 3) : (hash ^= ~(hash << 11 ^ 0x10000 ^ hash >> 5));
            }
            if (segmentID >= segmentNum - 1) continue;
            if ((index++ & 1) == 0) {
                hash ^= hash << 7 ^ 0x2E ^ hash >> 3;
                continue;
            }
            hash ^= ~(hash << 11 ^ 0x2E ^ hash >> 5);
        }
        return new TSeriesPartitionSlot((hash &= Integer.MAX_VALUE) % this.seriesPartitionSlotNum);
    }
}

