/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.backends.cassandra.init.configuration.CassandraConsistenciesConfiguration;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;

public class CassandraModSeqProvider
implements ModSeqProvider {
    public static final String MOD_SEQ_CONDITION = "modSeqCondition";
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final long maxModSeqRetries;
    private final PreparedStatement select;
    private final PreparedStatement update;
    private final PreparedStatement insert;
    private final ConsistencyLevel consistencyLevel;

    private static <T> T unbox(Supplier<T> supplier) throws MailboxException {
        try {
            return supplier.get();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof ExceptionRelay) {
                throw ((ExceptionRelay)e.getCause()).getUnderlying();
            }
            throw e;
        }
    }

    @Inject
    public CassandraModSeqProvider(Session session, CassandraConfiguration cassandraConfiguration, CassandraConsistenciesConfiguration consistenciesConfiguration) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.consistencyLevel = consistenciesConfiguration.getLightweightTransaction();
        this.maxModSeqRetries = cassandraConfiguration.getModSeqMaxRetry();
        this.insert = this.prepareInsert(session);
        this.update = this.prepareUpdate(session);
        this.select = this.prepareSelect(session);
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"modseq").value("nextModseq", (Object)QueryBuilder.bindMarker((String)"nextModseq")).value("mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId")).ifNotExists());
    }

    private PreparedStatement prepareUpdate(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.update((String)"modseq").onlyIf(QueryBuilder.eq((String)"nextModseq", (Object)QueryBuilder.bindMarker((String)MOD_SEQ_CONDITION))).with(QueryBuilder.set((String)"nextModseq", (Object)QueryBuilder.bindMarker((String)"nextModseq"))).where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"nextModseq"}).from("modseq").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
    }

    public ModSeq nextModSeq(Mailbox mailbox) throws MailboxException {
        return (ModSeq)this.nextModSeqReactive(mailbox.getMailboxId()).blockOptional().orElseThrow(() -> new MailboxException("Can not retrieve modseq for " + mailbox.getMailboxId()));
    }

    public ModSeq nextModSeq(MailboxId mailboxId) throws MailboxException {
        return (ModSeq)this.nextModSeqReactive(mailboxId).blockOptional().orElseThrow(() -> new MailboxException("Can not retrieve modseq for " + mailboxId));
    }

    public ModSeq highestModSeq(Mailbox mailbox) throws MailboxException {
        return this.highestModSeq(mailbox.getMailboxId());
    }

    public ModSeq highestModSeq(MailboxId mailboxId) throws MailboxException {
        return CassandraModSeqProvider.unbox(() -> ((Optional)this.findHighestModSeq((CassandraId)mailboxId).block()).orElse(ModSeq.first()));
    }

    private Mono<Optional<ModSeq>> findHighestModSeq(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeSingleRowOptional(this.select.bind().setUUID("mailboxId", mailboxId.asUuid()).setConsistencyLevel(this.consistencyLevel)).map(maybeRow -> maybeRow.map(row -> ModSeq.of((long)row.getLong("nextModseq"))));
    }

    private Mono<ModSeq> tryInsertModSeq(CassandraId mailboxId, ModSeq modSeq) {
        ModSeq nextModSeq = modSeq.next();
        return this.cassandraAsyncExecutor.executeReturnApplied((Statement)this.insert.bind().setUUID("mailboxId", mailboxId.asUuid()).setLong("nextModseq", nextModSeq.asLong())).map(success -> this.successToModSeq(nextModSeq, (Boolean)success)).handle(ReactorUtils.publishIfPresent());
    }

    private Mono<ModSeq> tryUpdateModSeq(CassandraId mailboxId, ModSeq modSeq) {
        ModSeq nextModSeq = modSeq.next();
        return this.cassandraAsyncExecutor.executeReturnApplied((Statement)this.update.bind().setUUID("mailboxId", mailboxId.asUuid()).setLong("nextModseq", nextModSeq.asLong()).setLong(MOD_SEQ_CONDITION, modSeq.asLong())).map(success -> this.successToModSeq(nextModSeq, (Boolean)success)).handle(ReactorUtils.publishIfPresent());
    }

    private Optional<ModSeq> successToModSeq(ModSeq modSeq, Boolean success) {
        if (success.booleanValue()) {
            return Optional.of(modSeq);
        }
        return Optional.empty();
    }

    public Mono<ModSeq> nextModSeqReactive(MailboxId mailboxId) {
        CassandraId cassandraId = (CassandraId)mailboxId;
        Duration firstBackoff = Duration.ofMillis(10L);
        return this.findHighestModSeq(cassandraId).flatMap(maybeHighestModSeq -> maybeHighestModSeq.map(highestModSeq -> this.tryUpdateModSeq(cassandraId, (ModSeq)highestModSeq)).orElseGet(() -> this.tryInsertModSeq(cassandraId, ModSeq.first()))).single().retryWhen((Retry)Retry.backoff((long)this.maxModSeqRetries, (Duration)firstBackoff).scheduler(Schedulers.elastic()));
    }

    public static class ExceptionRelay
    extends RuntimeException {
        private final MailboxException underlying;

        public ExceptionRelay(MailboxException underlying) {
            super(underlying);
            this.underlying = underlying;
        }

        public MailboxException getUnderlying() {
            return this.underlying;
        }
    }
}

