/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.james.mailbox.AttachmentContentLoader;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.AttachmentNotFoundException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import reactor.core.publisher.Mono;

public interface AttachmentManager
extends AttachmentContentLoader {
    public boolean exists(AttachmentId var1, MailboxSession var2) throws MailboxException;

    public AttachmentMetadata getAttachment(AttachmentId var1, MailboxSession var2) throws MailboxException, AttachmentNotFoundException;

    public Mono<AttachmentMetadata> getAttachmentReactive(AttachmentId var1, MailboxSession var2);

    public List<AttachmentMetadata> getAttachments(List<AttachmentId> var1, MailboxSession var2) throws MailboxException;

    public InputStream loadAttachmentContent(AttachmentId var1, MailboxSession var2) throws AttachmentNotFoundException, IOException;

    public Mono<InputStream> loadAttachmentContentReactive(AttachmentId var1, MailboxSession var2);

    @Override
    default public InputStream load(AttachmentMetadata attachment, MailboxSession mailboxSession) throws IOException, AttachmentNotFoundException {
        return this.loadAttachmentContent(attachment.getAttachmentId(), mailboxSession);
    }

    @Override
    default public Mono<InputStream> loadReactive(AttachmentMetadata attachment, MailboxSession mailboxSession) {
        return this.loadAttachmentContentReactive(attachment.getAttachmentId(), mailboxSession);
    }
}

