/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers.dlp;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.predicates.ThrowingPredicate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.james.core.MailAddress;
import org.apache.james.dlp.api.DLPConfigurationItem;
import org.apache.james.javax.AddressHelper;
import org.apache.james.javax.MultipartUtil;
import org.apache.mailet.Mail;

public class DlpDomainRules {
    private final ImmutableCollection<Rule> rules;

    @VisibleForTesting
    static DlpDomainRules matchNothing() {
        return DlpDomainRules.of(new Rule(DLPConfigurationItem.Id.of((String)"always false"), mail -> false));
    }

    @VisibleForTesting
    static DlpDomainRules matchAll() {
        return DlpDomainRules.of(new Rule(DLPConfigurationItem.Id.of((String)"always true"), mail -> true));
    }

    private static DlpDomainRules of(Rule rule) {
        return new DlpDomainRules((ImmutableCollection<Rule>)ImmutableList.of((Object)rule));
    }

    public static DlpDomainRulesBuilder builder() {
        return new DlpDomainRulesBuilder();
    }

    private DlpDomainRules(ImmutableCollection<Rule> rules) {
        this.rules = rules;
    }

    public Optional<DLPConfigurationItem.Id> match(Mail mail) {
        return this.rules.stream().filter(rule -> rule.match(mail)).map(Rule::id).findFirst();
    }

    static class Rule {
        private final DLPConfigurationItem.Id id;
        private final MatcherFunction matcher;

        public Rule(DLPConfigurationItem.Id id, MatcherFunction matcher) {
            this.id = id;
            this.matcher = matcher;
        }

        public DLPConfigurationItem.Id id() {
            return this.id;
        }

        public boolean match(Mail mail) {
            return this.matcher.test(mail);
        }

        public boolean equals(Object o) {
            if (o instanceof Rule) {
                Rule other = (Rule)o;
                return Objects.equals(this.id, other.id) && Objects.equals(this.matcher, other.matcher);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.matcher);
        }

        static interface MatcherFunction
        extends ThrowingPredicate<Mail> {
        }

        private static class SenderMatcher
        implements MatcherFunction {
            private final Pattern pattern;

            private SenderMatcher(Pattern pattern) {
                this.pattern = pattern;
            }

            public boolean doTest(Mail mail) throws MessagingException {
                return this.listSenders(mail).anyMatch(this.pattern.asPredicate());
            }

            private Stream<String> listSenders(Mail mail) throws MessagingException {
                return Stream.concat(this.listEnvelopSender(mail), this.listFromHeaders(mail));
            }

            private Stream<String> listEnvelopSender(Mail mail) {
                return mail.getMaybeSender().asStream().map(MailAddress::asString);
            }

            private Stream<String> listFromHeaders(Mail mail) throws MessagingException {
                MimeMessage message = mail.getMessage();
                if (message != null) {
                    return AddressHelper.asStringStream((Address[])message.getFrom());
                }
                return Stream.of(new String[0]);
            }
        }

        private static class RecipientsMatcher
        implements MatcherFunction {
            private final Pattern pattern;

            private RecipientsMatcher(Pattern pattern) {
                this.pattern = pattern;
            }

            public boolean doTest(Mail mail) throws MessagingException, IOException {
                return this.listRecipientsAsString(mail).anyMatch(this.pattern.asPredicate());
            }

            private Stream<String> listRecipientsAsString(Mail mail) throws MessagingException {
                return Stream.concat(this.listEnvelopRecipients(mail), this.listHeaderRecipients(mail));
            }

            private Stream<String> listEnvelopRecipients(Mail mail) {
                return mail.getRecipients().stream().map(MailAddress::asString);
            }

            private Stream<String> listHeaderRecipients(Mail mail) throws MessagingException {
                return Optional.ofNullable(mail.getMessage()).flatMap(Throwing.function(m -> Optional.ofNullable(m.getAllRecipients()))).map(AddressHelper::asStringStream).orElse(Stream.of(new String[0]));
            }
        }

        private static class ContentMatcher
        implements MatcherFunction {
            private final Pattern pattern;

            private ContentMatcher(Pattern pattern) {
                this.pattern = pattern;
            }

            public boolean doTest(Mail mail) throws MessagingException, IOException {
                return Stream.concat(this.getMessageSubjects(mail), this.getMessageBodies((Message)mail.getMessage())).anyMatch(this.pattern.asPredicate());
            }

            private Stream<String> getMessageSubjects(Mail mail) throws MessagingException {
                String subject;
                MimeMessage message = mail.getMessage();
                if (message != null && (subject = message.getSubject()) != null) {
                    return Stream.of(subject);
                }
                return Stream.of(new String[0]);
            }

            private Stream<String> getMessageBodies(Message message) throws MessagingException, IOException {
                if (message != null) {
                    return this.getMessageBodiesFromContent(message.getContent());
                }
                return Stream.of(new String[0]);
            }

            private Stream<String> getMessageBodiesFromContent(Object content) throws IOException, MessagingException {
                if (content instanceof String) {
                    return Stream.of((String)content);
                }
                return this.extractContentsComplexType(content).flatMap(Throwing.function(this::getMessageBodiesFromContent).sneakyThrow());
            }

            private Stream<Object> extractContentsComplexType(Object content) throws IOException, MessagingException {
                if (content instanceof Message) {
                    Message message = (Message)content;
                    return Stream.of(message.getContent());
                }
                if (content instanceof Multipart) {
                    return MultipartUtil.retrieveBodyParts((Multipart)((Multipart)content)).stream().map(Throwing.function(Part::getContent).sneakyThrow());
                }
                return Stream.of(new Object[0]);
            }
        }
    }

    public static class DlpDomainRulesBuilder {
        private final ImmutableMultimap.Builder<DLPConfigurationItem.Targets.Type, Rule> rules = ImmutableMultimap.builder();

        private DlpDomainRulesBuilder() {
        }

        public DlpDomainRulesBuilder recipientRule(DLPConfigurationItem.Id id, Pattern pattern) {
            return this.rule(DLPConfigurationItem.Targets.Type.Recipient, id, pattern);
        }

        public DlpDomainRulesBuilder senderRule(DLPConfigurationItem.Id id, Pattern pattern) {
            return this.rule(DLPConfigurationItem.Targets.Type.Sender, id, pattern);
        }

        public DlpDomainRulesBuilder contentRule(DLPConfigurationItem.Id id, Pattern pattern) {
            return this.rule(DLPConfigurationItem.Targets.Type.Content, id, pattern);
        }

        public DlpDomainRulesBuilder rule(DLPConfigurationItem.Targets.Type type, DLPConfigurationItem.Id id, Pattern regexp) {
            this.rules.put((Object)type, (Object)this.toRule(type, id, regexp));
            return this;
        }

        private Rule toRule(DLPConfigurationItem.Targets.Type type, DLPConfigurationItem.Id id, Pattern pattern) {
            switch (type) {
                case Sender: {
                    return new Rule(id, new Rule.SenderMatcher(pattern));
                }
                case Content: {
                    return new Rule(id, new Rule.ContentMatcher(pattern));
                }
                case Recipient: {
                    return new Rule(id, new Rule.RecipientsMatcher(pattern));
                }
            }
            throw new IllegalArgumentException("unexpected value");
        }

        public DlpDomainRules build() {
            ImmutableMultimap rules = this.rules.build();
            Preconditions.checkState((!this.containsDuplicateIds((ImmutableMultimap<DLPConfigurationItem.Targets.Type, Rule>)rules) ? 1 : 0) != 0, (Object)"Rules should not contain duplicated `id`");
            return new DlpDomainRules((ImmutableCollection<Rule>)rules.values());
        }

        private boolean containsDuplicateIds(ImmutableMultimap<DLPConfigurationItem.Targets.Type, Rule> rules) {
            return Stream.of(DLPConfigurationItem.Targets.Type.values()).map(arg_0 -> rules.get(arg_0)).anyMatch(this::containsDuplicateIds);
        }

        private boolean containsDuplicateIds(ImmutableCollection<Rule> rules) {
            long distinctIdCount = rules.stream().map(Rule::id).distinct().count();
            return distinctIdCount != (long)rules.size();
        }
    }
}

