/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph.binary;

import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.internal.core.data.geometry.Distance;
import com.datastax.dse.driver.internal.core.graph.binary.AbstractSimpleGraphBinaryCustomSerializer;
import com.datastax.dse.driver.internal.core.graph.binary.GraphBinaryUtils;
import java.io.IOException;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;

public class DistanceSerializer
extends AbstractSimpleGraphBinaryCustomSerializer<Distance> {
    public String getTypeName() {
        return "driver.dse.geometry.Distance";
    }

    @Override
    protected Distance readCustomValue(int valueLength, Buffer buffer, GraphBinaryReader context) throws IOException {
        Point p = (Point)context.readValue(buffer, Point.class, false);
        this.checkValueSize(GraphBinaryUtils.sizeOfDistance(p), valueLength);
        return new Distance(p, (Double)context.readValue(buffer, Double.class, false));
    }

    @Override
    protected void writeCustomValue(Distance value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.writeValue((Object)GraphBinaryUtils.sizeOfDistance(value.getCenter()), buffer, false);
        context.writeValue((Object)value.getCenter(), buffer, false);
        context.writeValue((Object)value.getRadius(), buffer, false);
    }
}

