/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.james.core.MailAddress;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.utils.GuiceProbe;
import org.apache.mailet.Mail;

public class MailRepositoryProbeImpl
implements GuiceProbe {
    private final MailRepositoryStore repositoryStore;

    @Inject
    public MailRepositoryProbeImpl(MailRepositoryStore repositoryStore) {
        this.repositoryStore = repositoryStore;
    }

    public long getRepositoryMailCount(MailRepositoryUrl url) throws Exception {
        return this.repositoryStore.select(url).size();
    }

    public void createRepository(MailRepositoryUrl url) throws Exception {
        this.repositoryStore.select(url);
    }

    public List<MailKey> listMailKeys(MailRepositoryUrl url) throws Exception {
        return ImmutableList.copyOf((Iterator)this.repositoryStore.select(url).list());
    }

    public Stream<Mail> listMails(MailRepositoryUrl url) throws Exception {
        return this.listMailKeys(url).stream().map(Throwing.function(key -> this.getMail(url, (MailKey)key)));
    }

    public List<Mail> listMails(MailRepositoryUrl url, MailAddress recipient) throws Exception {
        return (List)this.listMails(url).filter((Predicate<Mail>)Throwing.predicate(mail -> mail.getRecipients().contains(recipient))).collect(ImmutableList.toImmutableList());
    }

    public Mail getMail(MailRepositoryUrl url, MailKey key) throws Exception {
        return this.repositoryStore.select(url).retrieve(key);
    }

    public List<MailRepositoryUrl> listRepositoryUrls() {
        return (List)this.repositoryStore.getUrls().collect(ImmutableList.toImmutableList());
    }

    public MailRepositoryStore getMailRepositoryStore() {
        return this.repositoryStore;
    }
}

