/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.quota;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class QuotaScope {
    public static final QuotaScope GLOBAL = QuotaScope.of("global");
    public static final QuotaScope DOMAIN = QuotaScope.of("domain");
    public static final QuotaScope USER = QuotaScope.of("user");
    private final String value;

    public static QuotaScope of(String value) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)value), (Object)"`value` is mandatory");
        return new QuotaScope(value);
    }

    private QuotaScope(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaScope) {
            QuotaScope other = (QuotaScope)o;
            return Objects.equals(this.value, other.value);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
    }
}

