/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import jakarta.mail.Flags;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.CassandraApplicableFlagDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraDeletedMessageDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraFirstUnseenDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxCounterDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxRecentsDAO;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.concurrent.Queues;

public class CassandraIndexTableHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraIndexTableHandler.class);
    private final CassandraMailboxRecentsDAO mailboxRecentDAO;
    private final CassandraMailboxCounterDAO mailboxCounterDAO;
    private final CassandraFirstUnseenDAO firstUnseenDAO;
    private final CassandraApplicableFlagDAO applicableFlagDAO;
    private final CassandraDeletedMessageDAO deletedMessageDAO;

    @Inject
    public CassandraIndexTableHandler(CassandraMailboxRecentsDAO mailboxRecentDAO, CassandraMailboxCounterDAO mailboxCounterDAO, CassandraFirstUnseenDAO firstUnseenDAO, CassandraApplicableFlagDAO applicableFlagDAO, CassandraDeletedMessageDAO deletedMessageDAO) {
        this.mailboxRecentDAO = mailboxRecentDAO;
        this.mailboxCounterDAO = mailboxCounterDAO;
        this.firstUnseenDAO = firstUnseenDAO;
        this.applicableFlagDAO = applicableFlagDAO;
        this.deletedMessageDAO = deletedMessageDAO;
    }

    public Mono<Void> updateIndexOnDelete(ComposedMessageIdWithMetaData composedMessageIdWithMetaData, CassandraId mailboxId) {
        MessageUid uid = composedMessageIdWithMetaData.getComposedMessageId().getUid();
        return Flux.mergeDelayError((int)Queues.XS_BUFFER_SIZE, (Publisher[])new Publisher[]{this.updateFirstUnseenOnDelete(mailboxId, composedMessageIdWithMetaData.getFlags(), composedMessageIdWithMetaData.getComposedMessageId().getUid()), this.mailboxRecentDAO.removeFromRecent(mailboxId, composedMessageIdWithMetaData.getComposedMessageId().getUid()), this.updateDeletedMessageProjectionOnDelete(mailboxId, uid, composedMessageIdWithMetaData.getFlags()), this.decrementCountersOnDelete(mailboxId, composedMessageIdWithMetaData.getFlags())}).then();
    }

    public Mono<Void> updateIndexOnDelete(CassandraId mailboxId, Collection<MessageMetaData> metaData) {
        return Flux.mergeDelayError((int)Queues.XS_BUFFER_SIZE, (Publisher[])new Publisher[]{this.updateFirstUnseenOnDeleteWithMetadata(mailboxId, metaData), this.updateRecentOnDeleteWithMetadata(mailboxId, metaData), this.updateDeletedMessageProjectionOnDeleteWithMetadata(mailboxId, metaData), this.decrementCountersOnDelete(mailboxId, metaData)}).then();
    }

    public Mono<Void> updateIndexOnDeleteComposedId(CassandraId mailboxId, Collection<ComposedMessageIdWithMetaData> metaData) {
        return Flux.mergeDelayError((int)Queues.XS_BUFFER_SIZE, (Publisher[])new Publisher[]{this.updateFirstUnseenOnDelete(mailboxId, metaData), this.updateRecentOnDeleteWithComposeId(mailboxId, metaData), this.updateDeletedMessageProjectionOnDelete(mailboxId, metaData), this.decrementCountersOnDeleteFlags(mailboxId, (Collection)metaData.stream().map(ComposedMessageIdWithMetaData::getFlags).collect(ImmutableList.toImmutableList()))}).then();
    }

    private Mono<Void> updateRecentOnDeleteWithMetadata(CassandraId mailboxId, Collection<MessageMetaData> metaDatas) {
        return this.mailboxRecentDAO.removeFromRecent(mailboxId, metaDatas.stream().filter(metaData -> metaData.getFlags().contains(Flags.Flag.RECENT)).map(MessageMetaData::getUid).collect(Collectors.toList()));
    }

    private Mono<Void> updateRecentOnDeleteWithComposeId(CassandraId mailboxId, Collection<ComposedMessageIdWithMetaData> composedMessageIdWithMetaDatas) {
        return this.mailboxRecentDAO.removeFromRecent(mailboxId, composedMessageIdWithMetaDatas.stream().filter(composedId -> composedId.getFlags().contains(Flags.Flag.RECENT)).map(composedId -> composedId.getComposedMessageId().getUid()).collect(Collectors.toList()));
    }

    private Mono<Void> updateDeletedMessageProjectionOnDelete(CassandraId mailboxId, MessageUid uid, Flags flags) {
        if (flags.contains(Flags.Flag.DELETED)) {
            return this.deletedMessageDAO.removeDeleted(mailboxId, uid);
        }
        return Mono.empty();
    }

    private Mono<Void> updateDeletedMessageProjectionOnDelete(CassandraId mailboxId, Collection<ComposedMessageIdWithMetaData> metaDatas) {
        return this.deletedMessageDAO.removeDeleted(mailboxId, metaDatas.stream().filter(composedId -> composedId.getFlags().contains(Flags.Flag.DELETED)).map(composedId -> composedId.getComposedMessageId().getUid()).collect(Collectors.toList()));
    }

    private Mono<Void> updateDeletedMessageProjectionOnDeleteWithMetadata(CassandraId mailboxId, Collection<MessageMetaData> metaDatas) {
        return this.deletedMessageDAO.removeDeleted(mailboxId, metaDatas.stream().filter(metaData -> metaData.getFlags().contains(Flags.Flag.DELETED)).map(MessageMetaData::getUid).collect(Collectors.toList()));
    }

    public Mono<Void> updateIndexOnAdd(MailboxMessage message, CassandraId mailboxId) {
        Flags flags = message.createFlags();
        return Flux.mergeDelayError((int)Queues.XS_BUFFER_SIZE, (Publisher[])new Publisher[]{this.checkDeletedOnAdd(mailboxId, message.createFlags(), message.getUid()), this.updateFirstUnseenOnAdd(mailboxId, message.createFlags(), message.getUid()), this.addRecentOnSave(mailboxId, message), this.incrementCountersOnSave(mailboxId, flags), this.applicableFlagDAO.updateApplicableFlags(mailboxId, (Set<String>)ImmutableSet.copyOf((Object[])flags.getUserFlags()))}).then();
    }

    public Mono<Void> updateIndexOnAdd(Collection<MailboxMessage> messages, CassandraId mailboxId) {
        ImmutableSet userFlags = (ImmutableSet)messages.stream().flatMap(message -> Stream.of(message.createFlags().getUserFlags())).collect(ImmutableSet.toImmutableSet());
        List flags = (List)messages.stream().flatMap(message -> Stream.of(message.createFlags())).collect(ImmutableList.toImmutableList());
        return Flux.mergeDelayError((int)Queues.XS_BUFFER_SIZE, (Publisher[])new Publisher[]{this.checkDeletedOnAdd(mailboxId, messages), this.updateFirstUnseenOnAdd(mailboxId, messages), this.addRecentOnSave(mailboxId, messages), this.incrementCountersOnSave(mailboxId, flags), this.applicableFlagDAO.updateApplicableFlags(mailboxId, (Set<String>)userFlags)}).then();
    }

    public Mono<Void> updateIndexOnFlagsUpdate(CassandraId mailboxId, UpdatedFlags updatedFlags) {
        return this.updateIndexOnFlagsUpdate(mailboxId, (List<UpdatedFlags>)ImmutableList.of((Object)updatedFlags));
    }

    public Mono<Void> updateIndexOnFlagsUpdate(CassandraId mailboxId, List<UpdatedFlags> updatedFlags) {
        return Flux.mergeDelayError((int)Queues.XS_BUFFER_SIZE, (Publisher[])new Publisher[]{this.manageUnseenMessageCountsOnFlagsUpdate(mailboxId, updatedFlags), this.manageRecentOnFlagsUpdate(mailboxId, updatedFlags), this.updateFirstUnseenOnFlagsUpdate(mailboxId, updatedFlags), this.manageApplicableFlagsOnFlagsUpdate(mailboxId, updatedFlags), this.updateDeletedOnFlagsUpdate(mailboxId, updatedFlags)}).then();
    }

    private Mono<Void> manageApplicableFlagsOnFlagsUpdate(CassandraId mailboxId, List<UpdatedFlags> updatedFlags) {
        return this.applicableFlagDAO.updateApplicableFlags(mailboxId, (Set)updatedFlags.stream().flatMap(UpdatedFlags::userFlagStream).collect(ImmutableSet.toImmutableSet()));
    }

    private Mono<Void> updateDeletedOnFlagsUpdate(CassandraId mailboxId, List<UpdatedFlags> updatedFlags) {
        ImmutableList.Builder addDeletedUidsBuilder = ImmutableList.builder();
        ImmutableList.Builder removeDeletedUidsBuilder = ImmutableList.builder();
        updatedFlags.forEach(flag -> {
            if (flag.isModifiedToSet(Flags.Flag.DELETED)) {
                addDeletedUidsBuilder.add((Object)flag.getUid());
            } else if (flag.isModifiedToUnset(Flags.Flag.DELETED)) {
                removeDeletedUidsBuilder.add((Object)flag.getUid());
            }
        });
        return Flux.mergeDelayError((int)Queues.XS_BUFFER_SIZE, (Publisher[])new Publisher[]{this.deletedMessageDAO.addDeleted(mailboxId, (List<MessageUid>)addDeletedUidsBuilder.build()), this.deletedMessageDAO.removeDeleted(mailboxId, (List<MessageUid>)removeDeletedUidsBuilder.build())}).then();
    }

    private Mono<Void> decrementCountersOnDelete(CassandraId mailboxId, Flags flags) {
        if (flags.contains(Flags.Flag.SEEN)) {
            return this.mailboxCounterDAO.decrementCount(mailboxId).onErrorResume(e -> {
                LOGGER.error("Failed decrementing email count for {} upon delete", (Object)mailboxId.serialize());
                return Mono.empty();
            });
        }
        return this.mailboxCounterDAO.decrementUnseenAndCount(mailboxId).onErrorResume(e -> {
            LOGGER.error("Failed decrementing email count and seen for {} upon delete", (Object)mailboxId.serialize());
            return Mono.empty();
        });
    }

    private Mono<Void> decrementCountersOnDelete(CassandraId mailboxId, Collection<MessageMetaData> metaData) {
        return this.decrementCountersOnDeleteFlags(mailboxId, (Collection)metaData.stream().map(MessageMetaData::getFlags).collect(ImmutableList.toImmutableList()));
    }

    private Mono<Void> decrementCountersOnDeleteFlags(CassandraId mailboxId, Collection<Flags> flags) {
        long unseenCount = flags.stream().filter(flag -> !flag.contains(Flags.Flag.SEEN)).count();
        MailboxCounters counters = MailboxCounters.builder().mailboxId((MailboxId)mailboxId).count((long)flags.size()).unseen(unseenCount).build();
        return this.mailboxCounterDAO.remove(counters).onErrorResume(e -> {
            LOGGER.error("Failed decrementing counters {} upon delete", (Object)counters);
            return Mono.empty();
        });
    }

    private Mono<Void> incrementCountersOnSave(CassandraId mailboxId, Flags flags) {
        if (flags.contains(Flags.Flag.SEEN)) {
            return this.mailboxCounterDAO.incrementCount(mailboxId).onErrorResume(e -> {
                LOGGER.error("Failed incrementing email count and seen for {} upon save", (Object)mailboxId.serialize());
                return Mono.empty();
            });
        }
        return this.mailboxCounterDAO.incrementUnseenAndCount(mailboxId).onErrorResume(e -> {
            LOGGER.error("Failed incrementing email count and seen for {} upon save", (Object)mailboxId.serialize());
            return Mono.empty();
        });
    }

    private Mono<Void> incrementCountersOnSave(CassandraId mailboxId, Collection<Flags> flags) {
        long unseenCount = flags.stream().filter(flag -> !flag.contains(Flags.Flag.SEEN)).count();
        MailboxCounters counters = MailboxCounters.builder().mailboxId((MailboxId)mailboxId).count((long)flags.size()).unseen(unseenCount).build();
        return this.mailboxCounterDAO.add(counters).onErrorResume(e -> {
            LOGGER.error("Failed incrementing counters {} upon save", (Object)counters);
            return Mono.empty();
        });
    }

    private Mono<Void> addRecentOnSave(CassandraId mailboxId, MailboxMessage message) {
        if (message.createFlags().contains(Flags.Flag.RECENT)) {
            return this.mailboxRecentDAO.addToRecent(mailboxId, message.getUid());
        }
        return Mono.empty();
    }

    private Mono<Void> addRecentOnSave(CassandraId mailboxId, Collection<MailboxMessage> messages) {
        return this.mailboxRecentDAO.addToRecent(mailboxId, messages.stream().filter(message -> message.createFlags().contains(Flags.Flag.RECENT)).map(MailboxMessage::getUid).collect(Collectors.toList()));
    }

    private Mono<Void> manageUnseenMessageCountsOnFlagsUpdate(CassandraId mailboxId, List<UpdatedFlags> updatedFlags) {
        int sum = updatedFlags.stream().mapToInt(flags -> {
            if (flags.isModifiedToUnset(Flags.Flag.SEEN)) {
                return 1;
            }
            if (flags.isModifiedToSet(Flags.Flag.SEEN)) {
                return -1;
            }
            return 0;
        }).sum();
        if (sum != 0) {
            MailboxCounters counters = MailboxCounters.builder().mailboxId((MailboxId)mailboxId).count(0L).unseen((long)sum).build();
            return this.mailboxCounterDAO.add(counters).onErrorResume(e -> {
                LOGGER.error("Failed incrementing counters {} upon flags update", (Object)counters);
                return Mono.empty();
            });
        }
        return Mono.empty();
    }

    private Mono<Void> manageRecentOnFlagsUpdate(CassandraId mailboxId, List<UpdatedFlags> updatedFlags) {
        ImmutableList.Builder addRecentUidsBuilder = ImmutableList.builder();
        ImmutableList.Builder removeRecentUidsBuilder = ImmutableList.builder();
        updatedFlags.forEach(flag -> {
            if (flag.isModifiedToSet(Flags.Flag.RECENT)) {
                addRecentUidsBuilder.add((Object)flag.getUid());
            } else if (flag.isModifiedToUnset(Flags.Flag.RECENT)) {
                removeRecentUidsBuilder.add((Object)flag.getUid());
            }
        });
        return Flux.mergeDelayError((int)Queues.XS_BUFFER_SIZE, (Publisher[])new Publisher[]{this.mailboxRecentDAO.removeFromRecent(mailboxId, (List<MessageUid>)removeRecentUidsBuilder.build()), this.mailboxRecentDAO.addToRecent(mailboxId, (List<MessageUid>)addRecentUidsBuilder.build())}).then();
    }

    private Mono<Void> updateFirstUnseenOnAdd(CassandraId mailboxId, Flags flags, MessageUid uid) {
        if (flags.contains(Flags.Flag.SEEN)) {
            return Mono.empty();
        }
        return this.firstUnseenDAO.addUnread(mailboxId, uid);
    }

    private Mono<Void> updateFirstUnseenOnAdd(CassandraId mailboxId, Collection<MailboxMessage> mailboxMessages) {
        return this.firstUnseenDAO.addUnread(mailboxId, mailboxMessages.stream().filter(mailboxMessage -> !mailboxMessage.createFlags().contains(Flags.Flag.SEEN)).map(MailboxMessage::getUid).collect(Collectors.toList()));
    }

    private Mono<Void> checkDeletedOnAdd(CassandraId mailboxId, Flags flags, MessageUid uid) {
        if (flags.contains(Flags.Flag.DELETED)) {
            return this.deletedMessageDAO.addDeleted(mailboxId, uid);
        }
        return Mono.empty();
    }

    private Mono<Void> checkDeletedOnAdd(CassandraId mailboxId, Collection<MailboxMessage> mailboxMessages) {
        return this.deletedMessageDAO.addDeleted(mailboxId, mailboxMessages.stream().filter(message -> message.createFlags().contains(Flags.Flag.DELETED)).map(MailboxMessage::getUid).collect(Collectors.toList()));
    }

    private Mono<Void> updateFirstUnseenOnDelete(CassandraId mailboxId, Flags flags, MessageUid uid) {
        if (flags.contains(Flags.Flag.SEEN)) {
            return Mono.empty();
        }
        return this.firstUnseenDAO.removeUnread(mailboxId, uid);
    }

    private Mono<Void> updateFirstUnseenOnDeleteWithMetadata(CassandraId mailboxId, Collection<MessageMetaData> metaDatas) {
        return this.firstUnseenDAO.removeUnread(mailboxId, metaDatas.stream().filter(metaData -> !metaData.getFlags().contains(Flags.Flag.SEEN)).map(MessageMetaData::getUid).collect(Collectors.toList()));
    }

    private Mono<Void> updateFirstUnseenOnDelete(CassandraId mailboxId, Collection<ComposedMessageIdWithMetaData> composedMessageIdWithMetaData) {
        return this.firstUnseenDAO.removeUnread(mailboxId, composedMessageIdWithMetaData.stream().filter(composeId -> !composeId.getFlags().contains(Flags.Flag.SEEN)).map(composeId -> composeId.getComposedMessageId().getUid()).collect(Collectors.toList()));
    }

    private Mono<Void> updateFirstUnseenOnFlagsUpdate(CassandraId mailboxId, List<UpdatedFlags> updatedFlags) {
        ImmutableList.Builder addUnreadUidsBuilder = ImmutableList.builder();
        ImmutableList.Builder removeUnreadUidsBuilder = ImmutableList.builder();
        updatedFlags.forEach(flag -> {
            if (flag.isModifiedToUnset(Flags.Flag.SEEN)) {
                addUnreadUidsBuilder.add((Object)flag.getUid());
            } else if (flag.isModifiedToSet(Flags.Flag.SEEN)) {
                removeUnreadUidsBuilder.add((Object)flag.getUid());
            }
        });
        return Flux.mergeDelayError((int)Queues.XS_BUFFER_SIZE, (Publisher[])new Publisher[]{this.firstUnseenDAO.addUnread(mailboxId, (List<MessageUid>)addUnreadUidsBuilder.build()), this.firstUnseenDAO.removeUnread(mailboxId, (List<MessageUid>)removeUnreadUidsBuilder.build())}).then();
    }
}

