/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.github.fge.lambdas.Throwing;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.acl.PositiveUserACLDiff;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.table.CassandraUserMailboxRightsTable;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraUserMailboxRightsDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement delete;
    private final PreparedStatement insert;
    private final PreparedStatement select;
    private final PreparedStatement selectUser;

    @Inject
    public CassandraUserMailboxRightsDAO(CqlSession session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.delete = this.prepareDelete(session);
        this.insert = this.prepareInsert(session);
        this.select = this.prepareSelect(session);
        this.selectUser = this.prepareSelectAllForUser(session);
    }

    private PreparedStatement prepareDelete(CqlSession session) {
        return session.prepare(((Delete)QueryBuilder.deleteFrom((String)"UserMailboxACL").where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraUserMailboxRightsTable.USER_NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserMailboxRightsTable.USER_NAME)), (Relation)Relation.column((CqlIdentifier)CassandraUserMailboxRightsTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserMailboxRightsTable.MAILBOX_ID))})).build());
    }

    private PreparedStatement prepareInsert(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"UserMailboxACL").value(CassandraUserMailboxRightsTable.USER_NAME, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserMailboxRightsTable.USER_NAME)).value(CassandraUserMailboxRightsTable.MAILBOX_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserMailboxRightsTable.MAILBOX_ID)).value(CassandraUserMailboxRightsTable.RIGHTS, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserMailboxRightsTable.RIGHTS)).build());
    }

    private PreparedStatement prepareSelect(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"UserMailboxACL").column(CassandraUserMailboxRightsTable.RIGHTS).where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraUserMailboxRightsTable.USER_NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserMailboxRightsTable.USER_NAME)), (Relation)Relation.column((CqlIdentifier)CassandraUserMailboxRightsTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserMailboxRightsTable.MAILBOX_ID))})).build());
    }

    private PreparedStatement prepareSelectAllForUser(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"UserMailboxACL").columns(new CqlIdentifier[]{CassandraUserMailboxRightsTable.MAILBOX_ID, CassandraUserMailboxRightsTable.RIGHTS}).where((Relation)Relation.column((CqlIdentifier)CassandraUserMailboxRightsTable.USER_NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserMailboxRightsTable.USER_NAME)))).build());
    }

    public Mono<Void> update(CassandraId cassandraId, ACLDiff aclDiff) {
        PositiveUserACLDiff userACLDiff = new PositiveUserACLDiff(aclDiff);
        return Flux.merge((Publisher[])new Publisher[]{this.addAll(cassandraId, userACLDiff.addedEntries()), this.removeAll(cassandraId, userACLDiff.removedEntries()), this.addAll(cassandraId, userACLDiff.changedEntries())}).then();
    }

    private Flux<Void> removeAll(CassandraId cassandraId, Stream<MailboxACL.Entry> removedEntries) {
        return Flux.fromStream(removedEntries).flatMap(entry -> this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.delete.bind(new Object[0]).setString(CassandraUserMailboxRightsTable.USER_NAME, ((MailboxACL.EntryKey)entry.getKey()).getName())).setUuid(CassandraUserMailboxRightsTable.MAILBOX_ID, cassandraId.asUuid())), 16);
    }

    private Flux<Void> addAll(CassandraId cassandraId, Stream<MailboxACL.Entry> addedEntries) {
        return Flux.fromStream(addedEntries).flatMap(entry -> this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.insert.bind(new Object[0]).setString(CassandraUserMailboxRightsTable.USER_NAME, ((MailboxACL.EntryKey)entry.getKey()).getName())).setUuid(CassandraUserMailboxRightsTable.MAILBOX_ID, cassandraId.asUuid())).setString(CassandraUserMailboxRightsTable.RIGHTS, ((MailboxACL.Rfc4314Rights)entry.getValue()).serialize())), 16);
    }

    public Mono<Optional<MailboxACL.Rfc4314Rights>> retrieve(Username userName, CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeSingleRowOptional((Statement)((BoundStatement)this.select.bind(new Object[0]).setString(CassandraUserMailboxRightsTable.USER_NAME, userName.asString())).setUuid(CassandraUserMailboxRightsTable.MAILBOX_ID, mailboxId.asUuid())).map(rowOptional -> rowOptional.map(Throwing.function(row -> MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)row.getString(CassandraUserMailboxRightsTable.RIGHTS)))));
    }

    public Flux<Pair<CassandraId, MailboxACL.Rfc4314Rights>> listRightsForUser(Username userName) {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.selectUser.bind(new Object[0]).setString(CassandraUserMailboxRightsTable.USER_NAME, userName.asString())).map((Function)Throwing.function(this::toPair));
    }

    private Pair<CassandraId, MailboxACL.Rfc4314Rights> toPair(Row row) throws UnsupportedRightException {
        return Pair.of((Object)CassandraId.of(row.getUuid(CassandraUserMailboxRightsTable.MAILBOX_ID)), (Object)MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)row.getString(CassandraUserMailboxRightsTable.RIGHTS)));
    }
}

