/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.task;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaComponent;
import org.apache.james.mailbox.quota.task.RecomputeSingleComponentCurrentQuotasService;
import org.apache.james.mailbox.quota.task.RecomputeSingleQuotaComponentResult;
import org.apache.james.task.Task;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RecomputeCurrentQuotasService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecomputeCurrentQuotasService.class);
    private final UsersRepository usersRepository;
    private final Map<QuotaComponent, RecomputeSingleComponentCurrentQuotasService> recomputeSingleComponentCurrentQuotasServiceMap;

    @Inject
    public RecomputeCurrentQuotasService(UsersRepository usersRepository, Set<RecomputeSingleComponentCurrentQuotasService> recomputeSingleComponentCurrentQuotasServices) {
        this.usersRepository = usersRepository;
        this.recomputeSingleComponentCurrentQuotasServiceMap = recomputeSingleComponentCurrentQuotasServices.stream().collect(Collectors.toUnmodifiableMap(recomputeSingleComponentCurrentQuotasService -> recomputeSingleComponentCurrentQuotasService.getQuotaComponent(), recomputeSingleComponentCurrentQuotasService -> recomputeSingleComponentCurrentQuotasService));
    }

    public Mono<Task.Result> recomputeCurrentQuotas(Context context, RunningOptions runningOptions) {
        return Flux.from((Publisher)this.usersRepository.listReactive()).transform(ReactorUtils.throttle().elements(runningOptions.getUsersPerSecond()).per(Duration.ofSeconds(1L)).forOperation(username -> this.recomputeQuotasOfUser(runningOptions.getQuotaComponents(), context, (Username)username))).reduce((Object)Task.Result.COMPLETED, Task::combine).onErrorResume(UsersRepositoryException.class, e -> {
            LOGGER.error("Error while accessing users from repository", (Throwable)e);
            return Mono.just((Object)Task.Result.PARTIAL);
        });
    }

    private Mono<Task.Result> recomputeQuotasOfUser(List<QuotaComponent> quotaComponents, Context context, Username username) {
        if (quotaComponents.isEmpty()) {
            return Flux.merge((Iterable)this.recomputeSingleComponentCurrentQuotasServiceMap.values().stream().map(recomputeSingleComponentCurrentQuotasService -> this.recomputeCurrentQuotas((RecomputeSingleComponentCurrentQuotasService)recomputeSingleComponentCurrentQuotasService, context, username)).collect(Collectors.toUnmodifiableList())).reduce((Object)Task.Result.COMPLETED, Task::combine);
        }
        return Flux.fromIterable(quotaComponents).flatMap(quotaComponent -> (Publisher)Optional.ofNullable(this.recomputeSingleComponentCurrentQuotasServiceMap.get(quotaComponent)).map(recomputeSingleComponentCurrentQuotasService -> this.recomputeCurrentQuotas((RecomputeSingleComponentCurrentQuotasService)recomputeSingleComponentCurrentQuotasService, context, username)).orElse(Mono.just((Object)Task.Result.PARTIAL))).reduce((Object)Task.Result.COMPLETED, Task::combine);
    }

    public Mono<Task.Result> recomputeCurrentQuotas(RecomputeSingleComponentCurrentQuotasService recomputeSingleComponentCurrentQuotasService, Context context, Username username) {
        return recomputeSingleComponentCurrentQuotasService.recomputeCurrentQuotas(username).then(Mono.just((Object)Task.Result.COMPLETED)).doOnNext(any -> {
            LOGGER.info("jmap current upload usage quota recomputed for {}", (Object)username);
            context.getStatistic(recomputeSingleComponentCurrentQuotasService.getQuotaComponent()).incrementProcessed();
        }).onErrorResume(e -> {
            LOGGER.error("Error while recomputing jmap current upload usage quota for {}", (Object)username, e);
            context.getStatistic(recomputeSingleComponentCurrentQuotasService.getQuotaComponent()).addToFailedIdentifiers(username.asString());
            return Mono.just((Object)Task.Result.PARTIAL);
        });
    }

    public static class RunningOptions {
        public static final int DEFAULT_USERS_PER_SECOND = 1;
        public static final RunningOptions DEFAULT = RunningOptions.of(1, (List<QuotaComponent>)ImmutableList.of());
        private final int usersPerSecond;
        private final List<QuotaComponent> quotaComponents;

        public static RunningOptions of(int usersPerSecond, List<QuotaComponent> quotaComponent) {
            return new RunningOptions(usersPerSecond, quotaComponent);
        }

        public static RunningOptions withUsersPerSecond(int usersPerSecond) {
            return new RunningOptions(usersPerSecond, (List<QuotaComponent>)ImmutableList.of());
        }

        private RunningOptions(int usersPerSecond, List<QuotaComponent> quotaComponent) {
            Preconditions.checkArgument((usersPerSecond > 0 ? 1 : 0) != 0, (Object)"'usersPerSecond' needs to be strictly positive");
            this.usersPerSecond = usersPerSecond;
            this.quotaComponents = quotaComponent;
        }

        public int getUsersPerSecond() {
            return this.usersPerSecond;
        }

        public List<QuotaComponent> getQuotaComponents() {
            return this.quotaComponents;
        }
    }

    public static class Context {
        private Map<QuotaComponent, Statistic> mapQuotaComponentToStatistic;

        public Context() {
            this.mapQuotaComponentToStatistic = new ConcurrentHashMap<QuotaComponent, Statistic>();
        }

        public Context(Map<QuotaComponent, Statistic> mapQuotaComponentToStatistic) {
            this.mapQuotaComponentToStatistic = new ConcurrentHashMap<QuotaComponent, Statistic>(mapQuotaComponentToStatistic);
        }

        public Statistic getStatistic(QuotaComponent quotaComponent) {
            return this.mapQuotaComponentToStatistic.computeIfAbsent(quotaComponent, key -> new Statistic(new AtomicLong(), new ConcurrentLinkedDeque<String>()));
        }

        public Snapshot snapshot() {
            return new Snapshot(this.mapQuotaComponentToStatistic.entrySet().stream().map(quotaComponentStatisticEntry -> new RecomputeSingleQuotaComponentResult(((QuotaComponent)quotaComponentStatisticEntry.getKey()).getValue(), ((Statistic)quotaComponentStatisticEntry.getValue()).processedIdentifierCount.get(), (ImmutableList<String>)ImmutableList.copyOf(((Statistic)quotaComponentStatisticEntry.getValue()).failedIdentifiers))).collect(Collectors.toUnmodifiableList()));
        }

        public static class Statistic {
            private final AtomicLong processedIdentifierCount;
            private final ConcurrentLinkedDeque<String> failedIdentifiers;

            public Statistic(AtomicLong processedIdentifierCount, ConcurrentLinkedDeque<String> failedIdentifiers) {
                this.processedIdentifierCount = processedIdentifierCount;
                this.failedIdentifiers = failedIdentifiers;
            }

            public Statistic(long processedQuotaRootCount, Collection<String> failedQuotaRoots) {
                this.processedIdentifierCount = new AtomicLong(processedQuotaRootCount);
                this.failedIdentifiers = new ConcurrentLinkedDeque<String>(failedQuotaRoots);
            }

            public void incrementProcessed() {
                this.processedIdentifierCount.incrementAndGet();
            }

            public void addToFailedIdentifiers(String identifier) {
                this.failedIdentifiers.add(identifier);
            }
        }

        static class Snapshot {
            private final List<RecomputeSingleQuotaComponentResult> recomputeSingleQuotaComponentResults;

            private Snapshot(List<RecomputeSingleQuotaComponentResult> results) {
                this.recomputeSingleQuotaComponentResults = results;
            }

            public List<RecomputeSingleQuotaComponentResult> getResults() {
                return this.recomputeSingleQuotaComponentResults;
            }

            public final boolean equals(Object o) {
                if (o instanceof Snapshot) {
                    Snapshot that = (Snapshot)o;
                    return Objects.equals(this.recomputeSingleQuotaComponentResults, that.recomputeSingleQuotaComponentResults);
                }
                return false;
            }

            public final int hashCode() {
                return Objects.hash(this.recomputeSingleQuotaComponentResults);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("results", this.recomputeSingleQuotaComponentResults).toString();
            }
        }
    }
}

