/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import jakarta.inject.Inject;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.CreateRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.TooLongMailboxNameException;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class CreateProcessor
extends AbstractMailboxProcessor<CreateRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateProcessor.class);
    private final PathConverter.Factory pathConverterFactory;

    @Inject
    public CreateProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory, PathConverter.Factory pathConverterFactory) {
        super(CreateRequest.class, mailboxManager, factory, metricFactory);
        this.pathConverterFactory = pathConverterFactory;
    }

    @Override
    protected Mono<Void> processRequestReactive(CreateRequest request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxManager mailboxManager = this.getMailboxManager();
        return Mono.fromCallable(() -> this.pathConverterFactory.forSession(session).buildFullPath(request.getMailboxName())).flatMap(mailboxPath -> Mono.from((Publisher)mailboxManager.createMailboxReactive(mailboxPath, session.getMailboxSession()))).flatMap(mailboxId -> this.unsolicitedResponses(session, responder, false).then(Mono.fromRunnable(() -> this.okComplete(request, StatusResponse.ResponseCode.mailboxId(mailboxId), responder)))).onErrorResume(MailboxExistsException.class, e -> {
            this.no(request, responder, HumanReadableText.MAILBOX_EXISTS);
            return ReactorUtils.logAsMono(() -> LOGGER.debug("Create failed for mailbox {} as it already exists", (Object)request.getMailboxName(), e));
        }).onErrorResume(TooLongMailboxNameException.class, e -> {
            this.taggedBad(request, responder, HumanReadableText.FAILURE_MAILBOX_NAME);
            return ReactorUtils.logAsMono(() -> LOGGER.debug("The mailbox name length is over limit: {}", (Object)request.getMailboxName(), e));
        }).onErrorResume(MailboxException.class, e -> {
            this.no(request, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
            return ReactorUtils.logAsMono(() -> LOGGER.error("Create failed for mailbox {}", (Object)request.getMailboxName(), (Object)e));
        }).then();
    }

    @Override
    protected MDCBuilder mdc(CreateRequest request) {
        return MDCBuilder.create().addToContext("action", "CREATE").addToContext("mailbox", request.getMailboxName());
    }
}

