/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.util.Locale;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.util.LocaleUtil;
import org.apache.tika.parser.microsoft.TikaExcelGeneralFormat;

public class TikaExcelDataFormatter
extends DataFormatter {
    private String dateOverrideFormatString;

    public TikaExcelDataFormatter() {
        this(LocaleUtil.getUserLocale());
    }

    public TikaExcelDataFormatter(Locale locale) {
        super(locale);
        this.addFormat("General", new TikaExcelGeneralFormat(locale));
        this.addFormat("general", new TikaExcelGeneralFormat(locale));
    }

    public String formatRawCellContents(double value, int formatIndex, String formatString, boolean use1904Windowing) {
        if (DateUtil.isADateFormat((int)formatIndex, (String)formatString)) {
            String activeDateFormatString = this.dateOverrideFormatString == null ? formatString : this.dateOverrideFormatString;
            return super.formatRawCellContents(value, formatIndex, activeDateFormatString, use1904Windowing);
        }
        return super.formatRawCellContents(value, formatIndex, formatString, use1904Windowing);
    }

    public void setDateFormatOverride(String dateOverrideFormat) {
        if (dateOverrideFormat != null && dateOverrideFormat.trim().length() > 0) {
            this.dateOverrideFormatString = dateOverrideFormat;
        }
    }
}

