/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.icons;

import com.github.weisj.darklaf.icons.DerivableIcon;
import com.github.weisj.darklaf.util.FontUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;

public class TextIcon
implements Icon,
DerivableIcon<TextIcon> {
    private final String text;
    private final Color color;
    private final Font font;
    private final int width;
    private final int height;
    private final int textOffset;

    public TextIcon(String text, Color color, Font font, int width, int height) {
        this(text, color, font, width, height, 0);
    }

    public TextIcon(String text, Color color, Font font, int width, int height, int textOffset) {
        this.text = text;
        this.color = color;
        this.font = font;
        this.width = width;
        this.height = height;
        this.textOffset = textOffset;
    }

    @Override
    public void paintIcon(Component c, Graphics gg, int x, int y) {
        Graphics2D g = (Graphics2D)gg.create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        g.setFont(this.font);
        FontMetrics fm = g.getFontMetrics(this.font);
        int w = fm.stringWidth(this.text);
        int textX = x + (this.getIconWidth() - w) / 2;
        int textY = y + FontUtil.getCenteredFontPosition((int)this.height, (FontMetrics)fm) + fm.getAscent();
        g.setColor(this.color);
        g.drawString(this.text, textX, textY += this.textOffset);
        g.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public TextIcon derive(int width, int height) {
        int off = Math.round((float)height * ((float)this.textOffset / (float)this.height));
        Font f = this.font.deriveFont((float)height * (this.font.getSize2D() / (float)this.height));
        return new TextIcon(this.text, this.color, f, width, height, off);
    }
}

