/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.util.HashMap;
import java.util.Map;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Setting;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public abstract class ConnectionSettingsBase<T extends Throwable> {
    private final Log log = LogFactory.getLog(ConnectionSettingsBase.class);
    private final StringManager sm = StringManager.getManager(ConnectionSettingsBase.class);
    private final String connectionId;
    protected static final int MAX_WINDOW_SIZE = Integer.MAX_VALUE;
    protected static final int MIN_MAX_FRAME_SIZE = 16384;
    protected static final int MAX_MAX_FRAME_SIZE = 0xFFFFFF;
    protected static final long UNLIMITED = 0x100000000L;
    protected static final int MAX_HEADER_TABLE_SIZE = 65536;
    protected static final int DEFAULT_HEADER_TABLE_SIZE = 4096;
    protected static final boolean DEFAULT_ENABLE_PUSH = true;
    protected static final long DEFAULT_MAX_CONCURRENT_STREAMS = 0x100000000L;
    protected static final int DEFAULT_INITIAL_WINDOW_SIZE = 65535;
    protected static final int DEFAULT_MAX_FRAME_SIZE = 16384;
    protected static final long DEFAULT_MAX_HEADER_LIST_SIZE = 0x100000000L;
    protected Map<Setting, Long> current = new HashMap<Setting, Long>();
    protected Map<Setting, Long> pending = new HashMap<Setting, Long>();

    public ConnectionSettingsBase(String connectionId) {
        this.connectionId = connectionId;
        this.current.put(Setting.HEADER_TABLE_SIZE, 4096L);
        this.current.put(Setting.ENABLE_PUSH, 1L);
        this.current.put(Setting.MAX_CONCURRENT_STREAMS, 0x100000000L);
        this.current.put(Setting.INITIAL_WINDOW_SIZE, 65535L);
        this.current.put(Setting.MAX_FRAME_SIZE, 16384L);
        this.current.put(Setting.MAX_HEADER_LIST_SIZE, 0x100000000L);
    }

    public void set(Setting setting, long value) throws T {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.sm.getString("connectionSettings.debug", new Object[]{this.connectionId, setting, Long.toString(value)}));
        }
        switch (setting) {
            case HEADER_TABLE_SIZE: {
                this.validateHeaderTableSize(value);
                break;
            }
            case ENABLE_PUSH: {
                this.validateEnablePush(value);
                break;
            }
            case MAX_CONCURRENT_STREAMS: {
                break;
            }
            case INITIAL_WINDOW_SIZE: {
                this.validateInitialWindowSize(value);
                break;
            }
            case MAX_FRAME_SIZE: {
                this.validateMaxFrameSize(value);
                break;
            }
            case MAX_HEADER_LIST_SIZE: {
                break;
            }
            case UNKNOWN: {
                this.log.warn(this.sm.getString("connectionSettings.unknown", new Object[]{this.connectionId, setting, Long.toString(value)}));
                return;
            }
        }
        this.set(setting, (Long)value);
    }

    synchronized void set(Setting setting, Long value) {
        this.current.put(setting, value);
    }

    public int getHeaderTableSize() {
        return this.getMinInt(Setting.HEADER_TABLE_SIZE);
    }

    public boolean getEnablePush() {
        long result = this.getMin(Setting.ENABLE_PUSH);
        return result != 0L;
    }

    public long getMaxConcurrentStreams() {
        return this.getMax(Setting.MAX_CONCURRENT_STREAMS);
    }

    public int getInitialWindowSize() {
        return this.getMaxInt(Setting.INITIAL_WINDOW_SIZE);
    }

    public int getMaxFrameSize() {
        return this.getMaxInt(Setting.MAX_FRAME_SIZE);
    }

    public long getMaxHeaderListSize() {
        return this.getMax(Setting.MAX_HEADER_LIST_SIZE);
    }

    private synchronized long getMin(Setting setting) {
        Long pendingValue = this.pending.get((Object)setting);
        long currentValue = this.current.get((Object)setting);
        if (pendingValue == null) {
            return currentValue;
        }
        return Math.min(pendingValue, currentValue);
    }

    private synchronized int getMinInt(Setting setting) {
        long result = this.getMin(setting);
        if (result > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)result;
    }

    private synchronized long getMax(Setting setting) {
        Long pendingValue = this.pending.get((Object)setting);
        long currentValue = this.current.get((Object)setting);
        if (pendingValue == null) {
            return currentValue;
        }
        return Math.max(pendingValue, currentValue);
    }

    private synchronized int getMaxInt(Setting setting) {
        long result = this.getMax(setting);
        if (result > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)result;
    }

    private void validateHeaderTableSize(long headerTableSize) throws T {
        if (headerTableSize > 65536L) {
            String msg = this.sm.getString("connectionSettings.headerTableSizeLimit", this.connectionId, Long.toString(headerTableSize));
            this.throwException(msg, Http2Error.PROTOCOL_ERROR);
        }
    }

    private void validateEnablePush(long enablePush) throws T {
        if (enablePush > 1L) {
            String msg = this.sm.getString("connectionSettings.enablePushInvalid", this.connectionId, Long.toString(enablePush));
            this.throwException(msg, Http2Error.PROTOCOL_ERROR);
        }
    }

    private void validateInitialWindowSize(long initialWindowSize) throws T {
        if (initialWindowSize > Integer.MAX_VALUE) {
            String msg = this.sm.getString("connectionSettings.windowSizeTooBig", this.connectionId, Long.toString(initialWindowSize), Long.toString(Integer.MAX_VALUE));
            this.throwException(msg, Http2Error.FLOW_CONTROL_ERROR);
        }
    }

    private void validateMaxFrameSize(long maxFrameSize) throws T {
        if (maxFrameSize < 16384L || maxFrameSize > 0xFFFFFFL) {
            String msg = this.sm.getString("connectionSettings.maxFrameSizeInvalid", this.connectionId, Long.toString(maxFrameSize), Integer.toString(16384), Integer.toString(0xFFFFFF));
            this.throwException(msg, Http2Error.PROTOCOL_ERROR);
        }
    }

    abstract void throwException(String var1, Http2Error var2) throws T;
}

