/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx;

import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import io.vertx.core.Verticle;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.servicecomb.transport.common.TransportConfigUtils;
import org.apache.servicecomb.transport.rest.vertx.RestServerVerticle;
import org.springframework.util.StringUtils;

public final class TransportConfig {
    public static final int DEFAULT_SERVER_CONNECTION_IDLE_TIMEOUT_SECOND = 60;
    public static final boolean DEFAULT_SERVER_COMPRESSION_SUPPORT = false;
    public static final int DEFAULT_SERVER_MAX_HEADER_SIZE = 32768;
    public static final String SERVICECOMB_CORS_CONFIG_BASE = "servicecomb.cors";
    private static Class<? extends Verticle> restServerVerticle = RestServerVerticle.class;

    private TransportConfig() {
    }

    public static Class<? extends Verticle> getRestServerVerticle() {
        return restServerVerticle;
    }

    public static void setRestServerVerticle(Class<? extends Verticle> restServerVerticle) {
        TransportConfig.restServerVerticle = restServerVerticle;
    }

    public static String getAddress() {
        DynamicStringProperty address = DynamicPropertyFactory.getInstance().getStringProperty("servicecomb.rest.address", null);
        return address.get();
    }

    public static int getMaxFormAttributeSize() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.rest.server.maxFormAttributeSize", 2048).get();
    }

    public static int getCompressionLevel() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.rest.server.compressionLevel", 6).get();
    }

    public static int getMaxChunkSize() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.rest.server.maxChunkSize", 8192).get();
    }

    public static int getDecoderInitialBufferSize() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.rest.server.decoderInitialBufferSize", 128).get();
    }

    public static int getHttp2ConnectionWindowSize() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.rest.server.http2ConnectionWindowSize", -1).get();
    }

    public static int getThreadCount() {
        return TransportConfigUtils.readVerticleCount((String)"servicecomb.rest.server.verticle-count", (String)"servicecomb.rest.server.thread-count");
    }

    public static int getConnectionIdleTimeoutInSeconds() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.rest.server.connection.idleTimeoutInSeconds", 60).get();
    }

    public static boolean getCompressed() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.rest.server.compression", false).get();
    }

    public static boolean getDecompressionSupported() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.rest.server.decompressionSupported", false).get();
    }

    public static long getMaxConcurrentStreams() {
        return DynamicPropertyFactory.getInstance().getLongProperty("servicecomb.rest.server.http2.concurrentStreams", 100L).get();
    }

    public static long getHttp2HeaderTableSize() {
        return DynamicPropertyFactory.getInstance().getLongProperty("servicecomb.rest.server.http2.HeaderTableSize", 4096L).get();
    }

    public static boolean getPushEnabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.rest.server.http2.pushEnabled", true).get();
    }

    public static int getInitialWindowSize() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.rest.server.http2.initialWindowSize", 65535).get();
    }

    public static int getMaxFrameSize() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.rest.server.http2.maxFrameSize", 16384).get();
    }

    public static int getMaxHeaderListSize() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.rest.server.http2.maxHeaderListSize", Integer.MAX_VALUE).get();
    }

    public static boolean getUseAlpn() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.rest.server.http2.useAlpnEnabled", true).get();
    }

    public static int getMaxHeaderSize() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.rest.server.maxHeaderSize", 32768).get();
    }

    public static boolean isCorsEnabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.cors.enabled", false).get();
    }

    public static String getCorsAllowedOrigin() {
        return DynamicPropertyFactory.getInstance().getStringProperty("servicecomb.cors.origin", "*").get();
    }

    public static boolean isCorsAllowCredentials() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.cors.allowCredentials", false).get();
    }

    public static Set<String> getCorsAllowedHeaders() {
        String allowedHeaders = DynamicPropertyFactory.getInstance().getStringProperty("servicecomb.cors.allowedHeader", null).get();
        return TransportConfig.convertToSet(allowedHeaders);
    }

    public static Set<String> getCorsAllowedMethods() {
        String allowedMethods = DynamicPropertyFactory.getInstance().getStringProperty("servicecomb.cors.allowedMethod", null).get();
        return TransportConfig.convertToSet(allowedMethods);
    }

    public static Set<String> getCorsExposedHeaders() {
        String exposedHeaders = DynamicPropertyFactory.getInstance().getStringProperty("servicecomb.cors.exposedHeader", null).get();
        return TransportConfig.convertToSet(exposedHeaders);
    }

    public static int getCorsMaxAge() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.cors.maxAge", -1).get();
    }

    private static Set<String> convertToSet(String setString) {
        HashSet<String> resultSet = new HashSet<String>();
        if (!StringUtils.isEmpty((Object)setString)) {
            String[] arrString = setString.split(",");
            Stream.of(arrString).map(String::trim).filter(str -> !StringUtils.isEmpty((Object)str)).forEach(resultSet::add);
        }
        return resultSet;
    }

    public static int getMaxInitialLineLength() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.rest.server.maxInitialLineLength", 4096).get();
    }
}

