/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.mvc.EndpointMvcAdapter;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;

public class MvcEndpoints
implements ApplicationContextAware,
InitializingBean {
    private ApplicationContext applicationContext;
    private final Set<MvcEndpoint> endpoints = new HashSet<MvcEndpoint>();
    private Set<Class<?>> customTypes;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        Collection<MvcEndpoint> existing = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, MvcEndpoint.class).values();
        this.endpoints.addAll(existing);
        this.customTypes = this.findEndpointClasses(existing);
        Collection delegates = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, Endpoint.class).values();
        for (Endpoint endpoint : delegates) {
            if (!this.isGenericEndpoint(endpoint.getClass()) || !endpoint.isEnabled()) continue;
            EndpointMvcAdapter adapter = new EndpointMvcAdapter(endpoint);
            String path = this.determinePath(endpoint, this.applicationContext.getEnvironment());
            if (path != null) {
                adapter.setPath(path);
            }
            this.endpoints.add(adapter);
        }
    }

    private Set<Class<?>> findEndpointClasses(Collection<MvcEndpoint> existing) {
        HashSet types = new HashSet();
        for (MvcEndpoint endpoint : existing) {
            Class<? extends Endpoint> type = endpoint.getEndpointType();
            if (type == null) continue;
            types.add(type);
        }
        return types;
    }

    public Set<MvcEndpoint> getEndpoints() {
        return this.endpoints;
    }

    public <E extends MvcEndpoint> Set<E> getEndpoints(Class<E> type) {
        HashSet<MvcEndpoint> result = new HashSet<MvcEndpoint>(this.endpoints.size());
        for (MvcEndpoint candidate : this.endpoints) {
            if (!type.isInstance(candidate)) continue;
            result.add(candidate);
        }
        return Collections.unmodifiableSet(result);
    }

    private boolean isGenericEndpoint(Class<?> type) {
        return !this.customTypes.contains(type) && !MvcEndpoint.class.isAssignableFrom(type);
    }

    private String determinePath(Endpoint<?> endpoint, Environment environment) {
        ConfigurationProperties configurationProperties = (ConfigurationProperties)AnnotationUtils.findAnnotation(endpoint.getClass(), ConfigurationProperties.class);
        if (configurationProperties != null) {
            return environment.getProperty(configurationProperties.prefix() + ".path");
        }
        return null;
    }
}

