/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.rich;

import java.util.ArrayList;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.repository.MultiMetricRepository;
import org.springframework.boot.actuate.metrics.rich.RichGauge;
import org.springframework.boot.actuate.metrics.rich.RichGaugeReader;

public class MultiMetricRichGaugeReader
implements RichGaugeReader {
    private final MultiMetricRepository repository;

    public MultiMetricRichGaugeReader(MultiMetricRepository repository) {
        this.repository = repository;
    }

    @Override
    public RichGauge findOne(String name) {
        Iterable<Metric<?>> metrics = this.repository.findAll(name);
        double value = 0.0;
        double average = 0.0;
        double alpha = -1.0;
        double min = 0.0;
        double max = 0.0;
        long count = 0L;
        for (Metric<?> metric : metrics) {
            if (metric.getName().endsWith(".val")) {
                value = ((Number)metric.getValue()).doubleValue();
                continue;
            }
            if (metric.getName().endsWith(".alpha")) {
                alpha = ((Number)metric.getValue()).doubleValue();
                continue;
            }
            if (metric.getName().endsWith(".avg")) {
                average = ((Number)metric.getValue()).doubleValue();
                continue;
            }
            if (metric.getName().endsWith(".min")) {
                min = ((Number)metric.getValue()).doubleValue();
                continue;
            }
            if (metric.getName().endsWith(".max")) {
                max = ((Number)metric.getValue()).doubleValue();
                continue;
            }
            if (!metric.getName().endsWith(".count")) continue;
            count = ((Number)metric.getValue()).longValue();
        }
        return new RichGauge(name, value, alpha, average, max, min, count);
    }

    @Override
    public Iterable<RichGauge> findAll() {
        ArrayList<RichGauge> result = new ArrayList<RichGauge>();
        for (String name : this.repository.groups()) {
            result.add(this.findOne(name));
        }
        return result;
    }

    @Override
    public long count() {
        return this.repository.countGroups();
    }
}

