/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.sling.maven.projectsupport.BundleListUtils;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.Bundle;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class ArtifactDefinition {
    private String artifactId;
    private String classifier;
    private String groupId;
    private int startLevel;
    private String type;
    private String version;
    private String runModes;
    private ArtifactDefinition[] bundles;

    public ArtifactDefinition() {
    }

    public ArtifactDefinition(Bundle bundle, int startLevel) {
        this.groupId = bundle.getGroupId();
        this.artifactId = bundle.getArtifactId();
        this.type = bundle.getType();
        this.version = bundle.getVersion();
        this.classifier = bundle.getClassifier();
        this.startLevel = startLevel;
        this.runModes = bundle.getRunModes();
    }

    public ArtifactDefinition(Xpp3Dom config) {
        if (config.getChild("bundles") != null) {
            Xpp3Dom[] children = config.getChild("bundles").getChildren("bundle");
            this.bundles = new ArtifactDefinition[children.length];
            for (int i = 0; i < this.bundles.length; ++i) {
                this.bundles[i] = new ArtifactDefinition(children[i]);
            }
        } else {
            this.groupId = BundleListUtils.nodeValue(config, "groupId", null);
            this.artifactId = BundleListUtils.nodeValue(config, "artifactId", null);
            this.type = BundleListUtils.nodeValue(config, "type", null);
            this.version = BundleListUtils.nodeValue(config, "version", null);
            this.classifier = BundleListUtils.nodeValue(config, "classifier", null);
            this.startLevel = BundleListUtils.nodeValue(config, "startLevel", 0);
            this.runModes = BundleListUtils.nodeValue(config, "runModes", null);
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRunModes() {
        return this.runModes;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setStartLevel(int startLevel) {
        this.startLevel = startLevel;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ArtifactDefinition[] getContainedArtifacts() {
        return this.bundles;
    }

    public String toString() {
        if (this.bundles == null) {
            return "ArtifactDefinition [artifactId=" + this.artifactId + ", classifier=" + this.classifier + ", groupId=" + this.groupId + ", startLevel=" + this.startLevel + ", type=" + this.type + ", version=" + this.version + ", runModes=" + this.runModes + "]";
        }
        return "ArtifactDefinition [artifacts=" + Arrays.toString(this.bundles) + "]";
    }

    public void initDefaults(String commaDelimitedList) {
        this.initDefaults(commaDelimitedList, ',');
    }

    public void initDefaults(String valueList, char delimiter) {
        String delString = "" + delimiter;
        String[] values = valueList.split(delString);
        if (values.length == 0 || values.length % 6 != 0) {
            throw new IllegalArgumentException(String.format("The string %s does not have the correct number of items (a multiple of 6) separated by %s", valueList, delString));
        }
        if (values.length == 6) {
            this.initDefaults(values[0], values[1], values[2], values[3], values[4], Integer.valueOf(values[5]));
        } else {
            this.bundles = new ArtifactDefinition[values.length / 6];
            for (int i = 0; i < values.length / 6; ++i) {
                this.bundles[i] = new ArtifactDefinition();
                this.bundles[i].initDefaults(values[i * 6 + 0], values[i * 6 + 1], values[i * 6 + 2], values[i * 6 + 3], values[i * 6 + 4], Integer.valueOf(values[i * 6 + 5]));
            }
        }
    }

    public void initDefaults(String groupId, String artifactId, String version, String type, String classifier, int startLevel) {
        if (this.bundles == null) {
            if (this.groupId == null && StringUtils.isNotEmpty((String)groupId)) {
                this.groupId = groupId;
            }
            if (this.artifactId == null && StringUtils.isNotEmpty((String)artifactId)) {
                this.artifactId = artifactId;
            }
            if (this.version == null && StringUtils.isNotEmpty((String)version)) {
                this.version = version;
            }
            if (this.type == null && StringUtils.isNotEmpty((String)groupId)) {
                this.type = type;
            }
            if (this.classifier == null && StringUtils.isNotEmpty((String)classifier)) {
                this.classifier = classifier;
            }
            if (this.startLevel == 0) {
                this.startLevel = startLevel;
            }
        } else {
            for (ArtifactDefinition bundle : this.bundles) {
                bundle.initDefaults(groupId, artifactId, version, type, classifier, startLevel);
            }
        }
    }

    public List<Bundle> toBundleList() {
        ArrayList<Bundle> bundleList = new ArrayList<Bundle>();
        if (this.bundles == null) {
            Bundle bnd = new Bundle();
            bnd.setArtifactId(this.artifactId);
            bnd.setGroupId(this.groupId);
            bnd.setVersion(this.version);
            if (this.type != null) {
                bnd.setType(this.type);
            }
            bnd.setClassifier(this.classifier);
            bnd.setStartLevel(this.startLevel);
            bundleList.add(bnd);
        } else {
            for (ArtifactDefinition bundle : this.bundles) {
                bundleList.addAll(bundle.toBundleList());
            }
        }
        return bundleList;
    }

    public List<Dependency> toDependencyList(String scope) {
        ArrayList<Dependency> depList = new ArrayList<Dependency>();
        if (this.bundles == null) {
            Dependency dep = new Dependency();
            dep.setArtifactId(this.artifactId);
            dep.setGroupId(this.groupId);
            dep.setVersion(this.version);
            if (this.type != null) {
                dep.setType(this.type);
            }
            dep.setClassifier(this.classifier);
            dep.setScope(scope);
            depList.add(dep);
        } else {
            for (ArtifactDefinition bundle : this.bundles) {
                depList.addAll(bundle.toDependencyList(scope));
            }
        }
        return depList;
    }

    public static List<Dependency> toDependencyList(Bundle bundle, String scope) {
        return new ArtifactDefinition(bundle, 0).toDependencyList(scope);
    }
}

