/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.maven.projectsupport.AbstractUsingBundleListMojo;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.Bundle;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.BundleList;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.StartLevel;

@Mojo(name="create-paxrunner-provision-file", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST)
public class CreatePaxRunnerBundleProvisionFileMojo
extends AbstractUsingBundleListMojo {
    private static final String CLASSIFIER = "bundles";
    private static final String TYPE = "pax";
    @Parameter(defaultValue="${project.build.directory}/bundles-pax")
    private File outputFile;

    @Override
    protected void executeWithArtifacts() throws MojoExecutionException, MojoFailureException {
        FileWriter out = null;
        try {
            out = new FileWriter(this.outputFile);
            BundleList bundleList = this.getInitializedBundleList();
            for (StartLevel level : bundleList.getStartLevels()) {
                for (Bundle bundle : level.getBundles()) {
                    String line = String.format("mvn:%s/%s/%s@%d\n", bundle.getGroupId(), bundle.getArtifactId(), bundle.getVersion(), level.getStartLevel());
                    out.write(line);
                }
            }
            this.projectHelper.attachArtifact(this.project, TYPE, CLASSIFIER, this.outputFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write " + this.outputFile.getName(), (Exception)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

