/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.saml2;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.auth.saml2.SAML2RuntimeException;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.xmlsec.config.impl.JavaCryptoValidationInitializer;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private ConfigurationAdmin configAdmin;

    public void start(BundleContext context) throws IOException, InvalidSyntaxException {
        BundleWiring bundleWiring = (BundleWiring)context.getBundle().adapt(BundleWiring.class);
        ClassLoader loader = bundleWiring.getClassLoader();
        Thread thread = Thread.currentThread();
        thread.setContextClassLoader(InitializationService.class.getClassLoader());
        try {
            Activator.initializeOpenSaml();
        }
        catch (InitializationException e) {
            throw new SAML2RuntimeException("Java Cryptographic Extension could not initialize. This happens when JCE implementation is incomplete, and not meeting OpenSAML standards.", e);
        }
        finally {
            thread.setContextClassLoader(loader);
        }
        this.setConfigAdmin(context);
        if (this.needsSamlJaas()) {
            this.configureSamlJaas();
        }
    }

    public void stop(BundleContext context) throws IOException, InvalidSyntaxException {
        if (this.configAdmin != null) {
            this.removeSamlJaas();
        }
    }

    public static void initializeOpenSaml() throws InitializationException {
        JavaCryptoValidationInitializer jcvi = new JavaCryptoValidationInitializer();
        jcvi.init();
        InitializationService.initialize();
        logger.info("Activating Apache Sling SAML2 SP Bundle. And Initializing JCE, Java Cryptographic Extension");
        for (Provider jceProvider : Security.getProviders()) {
            logger.info(jceProvider.getInfo());
        }
    }

    protected void configureSamlJaas() throws IOException {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("jaas.classname", "org.apache.sling.auth.saml2.sp.Saml2LoginModule");
        ((Dictionary)props).put("jaas.controlFlag", "Sufficient");
        ((Dictionary)props).put("jaas.realmName", "jackrabbit.oak");
        ((Dictionary)props).put("jaas.ranking", 110);
        this.configAdmin.createFactoryConfiguration("org.apache.felix.jaas.Configuration.factory", null).update(props);
    }

    protected boolean needsSamlJaas() throws IOException, InvalidSyntaxException {
        Configuration[] configs = this.configAdmin.listConfigurations("(jaas.classname=org.apache.sling.auth.saml2.sp.Saml2LoginModule)");
        return configs == null;
    }

    protected void removeSamlJaas() throws IOException, InvalidSyntaxException {
        Configuration[] configs = this.configAdmin.listConfigurations("(jaas.classname=org.apache.sling.auth.saml2.sp.Saml2LoginModule)");
        if (configs == null) {
            return;
        }
        for (Configuration config : configs) {
            config.delete();
        }
    }

    public void setConfigAdmin(BundleContext bundleContext) {
        ServiceReference serviceReference = bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        this.configAdmin = (ConfigurationAdmin)bundleContext.getService(serviceReference);
    }
}

