/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.forms.impl.actions;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.text.StringSubstitutor;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.cms.reference.forms.FormAction;
import org.apache.sling.cms.reference.forms.FormActionResult;
import org.apache.sling.cms.reference.forms.FormException;
import org.apache.sling.cms.reference.forms.FormRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FormAction.class}, immediate=true)
public class DeleteUserGeneratedContentAction
implements FormAction {
    private static final Logger log = LoggerFactory.getLogger(DeleteUserGeneratedContentAction.class);
    private ResourceResolverFactory factory;

    @Activate
    public DeleteUserGeneratedContentAction(@Reference ResourceResolverFactory factory) {
        this.factory = factory;
    }

    @Override
    public FormActionResult handleForm(Resource actionResource, FormRequest request) throws FormException {
        FormActionResult formActionResult;
        block10: {
            log.trace("handleForm");
            ValueMap properties = actionResource.getValueMap();
            ResourceResolver resolver = this.getResourceResolver();
            try {
                StringSubstitutor sub = new StringSubstitutor((Map)request.getFormData());
                String path = sub.replace((String)properties.get("path", String.class));
                log.debug("Deleting UGC resource at path: {}", (Object)path);
                Resource resource = resolver.getResource(path);
                if (resource == null) {
                    throw new FormException("Could not find UGC resource at path: " + path);
                }
                Resource ugcParent = this.findUgcParent(resource);
                if (!request.getOriginalRequest().getResourceResolver().getUserID().equals(ugcParent.getValueMap().get("user", String.class))) {
                    throw new FormException("Cannot delete content not created by the current user");
                }
                resolver.delete(ugcParent);
                resolver.commit();
                log.debug("Successfully deleted user generated content");
                formActionResult = FormActionResult.success("Deleted user generated content");
                if (resolver == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (resolver != null) {
                        try {
                            resolver.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LoginException | PersistenceException e) {
                    throw new FormException("Failed to delete user generated content", e);
                }
            }
            resolver.close();
        }
        return formActionResult;
    }

    private Resource findUgcParent(Resource resource) throws FormException {
        if ("sling:UGC".equals(resource.getResourceType())) {
            return resource;
        }
        if (resource.getParent() != null) {
            return this.findUgcParent(resource.getParent());
        }
        throw new FormException("Failed to find UGC Parent");
    }

    private ResourceResolver getResourceResolver() throws LoginException {
        return this.factory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", "sling-cms-ugc"));
    }

    @Override
    public boolean handles(Resource actionResource) {
        return "reference/components/forms/actions/deleteugc".equals(actionResource.getResourceType());
    }
}

