/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.commons.log.logback.internal.AppenderOrigin;
import org.apache.sling.commons.log.logback.internal.LogConfigManager;
import org.apache.sling.commons.log.logback.internal.LogbackResetListener;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Converting;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.LoggerFactory;

public class AppenderTracker
extends ServiceTracker<Appender<ILoggingEvent>, Appender<ILoggingEvent>>
implements LogbackResetListener {
    static final String PROP_LOGGER = "loggers";
    private final LogConfigManager logConfigManager;
    private final Map<ServiceReference<Appender<ILoggingEvent>>, AppenderInfo> appenders = new ConcurrentHashMap<ServiceReference<Appender<ILoggingEvent>>, AppenderInfo>();

    public AppenderTracker(@NotNull BundleContext context, @NotNull LogConfigManager logConfigManager) throws InvalidSyntaxException {
        super(context, AppenderTracker.createFilter(), null);
        this.logConfigManager = logConfigManager;
    }

    @NotNull
    public Appender<ILoggingEvent> addingService(@NotNull ServiceReference<Appender<ILoggingEvent>> reference) {
        Appender appender = (Appender)super.addingService(reference);
        AppenderInfo ai = new AppenderInfo(reference, (Appender<ILoggingEvent>)appender);
        this.appenders.put(reference, ai);
        this.attachAppender(ai);
        return appender;
    }

    public void modifiedService(@NotNull ServiceReference<Appender<ILoggingEvent>> reference, @NotNull Appender<ILoggingEvent> service) {
        this.detachAppender(this.appenders.remove(reference));
        AppenderInfo nai = new AppenderInfo(reference, service);
        this.appenders.put(reference, nai);
        this.attachAppender(nai);
    }

    public void removedService(@NotNull ServiceReference<Appender<ILoggingEvent>> reference, @NotNull Appender<ILoggingEvent> service) {
        AppenderInfo ai = this.appenders.remove(reference);
        this.detachAppender(ai);
        super.removedService(reference, service);
    }

    @NotNull
    public Collection<AppenderInfo> getAppenderInfos() {
        return Collections.unmodifiableCollection(this.appenders.values());
    }

    @NotNull
    static Filter createFilter() throws InvalidSyntaxException {
        String filter = String.format("(&(objectClass=%s)(%s=*))", Appender.class.getName(), PROP_LOGGER);
        return FrameworkUtil.createFilter((String)filter);
    }

    @Override
    public void onResetComplete(@NotNull LoggerContext context) {
        for (AppenderInfo ai : this.appenders.values()) {
            this.attachAppender(ai);
        }
    }

    private void detachAppender(@NotNull AppenderInfo ai) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        for (String name : ai.getLoggers()) {
            Logger logger = loggerContext.getLogger(name);
            this.logConfigManager.maybeDetachAppender(AppenderOrigin.TRACKER, ai.name, logger);
        }
        ai.appender.stop();
    }

    private void attachAppender(@NotNull AppenderInfo ai) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ai.appender.setContext((Context)loggerContext);
        ai.appender.start();
        this.logConfigManager.addOrUpdateAppender(AppenderOrigin.TRACKER, ai.name, ai.appender, ai.getLoggers());
    }

    class AppenderInfo {
        private final Set<String> loggers;
        final Appender<ILoggingEvent> appender;
        final String pid;
        private final String name;

        public AppenderInfo(@NotNull ServiceReference<Appender<ILoggingEvent>> ref, Appender<ILoggingEvent> appender) {
            this.appender = appender;
            this.pid = ref.getProperty("service.id").toString();
            Set loggerNames = (Set)((Converting)Converters.standardConverter().convert(ref.getProperty(AppenderTracker.PROP_LOGGER)).defaultValue(Collections.emptySet())).to(Set.class);
            this.name = appender.getName();
            this.loggers = loggerNames;
            AppenderTracker.this.logConfigManager.addOrUpdateAppender(AppenderOrigin.TRACKER, this.name, appender, loggerNames);
        }

        @NotNull
        public Set<String> getLoggers() {
            HashSet<String> result = new HashSet<String>(this.loggers);
            Set<String> loggersFromConfig = AppenderTracker.this.logConfigManager.getLoggerNamesForKnownAppender(AppenderOrigin.JORAN_OSGI, this.name);
            result.addAll(loggersFromConfig);
            return Collections.unmodifiableSet(result);
        }
    }
}

