/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.threads.impl;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.sling.commons.threads.ThreadPool;
import org.apache.sling.commons.threads.ThreadPoolConfig;
import org.apache.sling.commons.threads.impl.DefaultThreadPool;

public final class ThreadPoolFacade
implements ThreadPool {
    private volatile DefaultThreadPool delegatee;
    private String name;

    public ThreadPoolFacade(DefaultThreadPool pool) {
        this.delegatee = pool;
        this.name = pool.getName();
    }

    @Override
    public void execute(Runnable runnable) {
        this.delegatee.execute(runnable);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.delegatee.submit(callable);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.delegatee.submit(runnable);
    }

    @Override
    public ThreadPoolConfig getConfiguration() {
        return this.delegatee.getConfiguration();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void shutdown() {
        this.delegatee.shutdown();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPool(DefaultThreadPool pool) {
        DefaultThreadPool oldPool = this.delegatee;
        this.delegatee = pool;
        oldPool.shutdown();
    }

    public ThreadPoolExecutor getExecutor() {
        return this.delegatee.getExecutor();
    }
}

