/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.agent.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sling.distribution.DistributionRequestState;
import org.apache.sling.distribution.DistributionResponse;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.event.impl.DistributionEventFactory;
import org.apache.sling.distribution.impl.SimpleDistributionResponse;
import org.apache.sling.distribution.log.impl.DefaultDistributionLog;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.impl.DistributionPackageProcessor;
import org.apache.sling.distribution.queue.DistributionQueueItemState;
import org.apache.sling.distribution.queue.DistributionQueueItemStatus;
import org.apache.sling.distribution.queue.impl.DistributionQueueDispatchingStrategy;
import org.apache.sling.distribution.queue.impl.DistributionQueueProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class QueueingDistributionPackageProcessor
implements DistributionPackageProcessor {
    private final String callingUser;
    private final String requestId;
    private final long requestStartTime;
    private final String agentName;
    private final AtomicInteger packagesCount = new AtomicInteger();
    private final AtomicLong packagesSize = new AtomicLong();
    private final List<DistributionResponse> allResponses = new LinkedList<DistributionResponse>();
    private final DistributionEventFactory distributionEventFactory;
    private final DistributionQueueDispatchingStrategy scheduleQueueStrategy;
    private final DistributionQueueProvider queueProvider;
    private final DefaultDistributionLog log;

    @Override
    public List<DistributionResponse> getAllResponses() {
        return this.allResponses;
    }

    @Override
    public int getPackagesCount() {
        return this.packagesCount.get();
    }

    @Override
    public long getPackagesSize() {
        return this.packagesSize.get();
    }

    QueueingDistributionPackageProcessor(@Nullable String callingUser, @NotNull String requestId, long requestStartTime, @NotNull DistributionEventFactory distributionEventFactory, @NotNull DistributionQueueDispatchingStrategy scheduleQueueStrategy, @NotNull DistributionQueueProvider queueProvider, @NotNull DefaultDistributionLog log, @NotNull String agentName) {
        this.callingUser = callingUser;
        this.requestId = requestId;
        this.requestStartTime = requestStartTime;
        this.distributionEventFactory = distributionEventFactory;
        this.scheduleQueueStrategy = scheduleQueueStrategy;
        this.queueProvider = queueProvider;
        this.log = log;
        this.agentName = agentName;
    }

    @Override
    public void process(DistributionPackage distributionPackage) {
        long startTime = System.currentTimeMillis();
        Collection<SimpleDistributionResponse> responses = this.scheduleImportPackage(distributionPackage, this.callingUser, this.requestId, this.requestStartTime);
        this.packagesCount.incrementAndGet();
        this.packagesSize.addAndGet(distributionPackage.getSize());
        this.allResponses.addAll(responses);
        long endTime = System.currentTimeMillis();
        this.log.debug("PACKAGE-QUEUED {}: packageId={}, paths={}, queueTime={}ms, responses={}", this.requestId, distributionPackage.getId(), distributionPackage.getInfo().getPaths(), endTime - startTime, responses.size());
    }

    private Collection<SimpleDistributionResponse> scheduleImportPackage(DistributionPackage distributionPackage, String callingUser, String requestId, long startTime) {
        LinkedList<SimpleDistributionResponse> distributionResponses = new LinkedList<SimpleDistributionResponse>();
        try {
            distributionPackage.getInfo().put("internal.request.user", callingUser);
            distributionPackage.getInfo().put("internal.request.id", requestId);
            distributionPackage.getInfo().put("internal.request.startTime", startTime);
            Iterable<DistributionQueueItemStatus> states = this.scheduleQueueStrategy.add(distributionPackage, this.queueProvider);
            for (DistributionQueueItemStatus state : states) {
                DistributionRequestState requestState = this.getRequestStateFromQueueState(state.getItemState());
                distributionResponses.add(new SimpleDistributionResponse(requestState, state.getItemState().toString()));
            }
            this.distributionEventFactory.generatePackageEvent("org/apache/sling/distribution/agent/package/queued", DistributionComponentKind.AGENT, this.agentName, distributionPackage.getInfo());
        }
        catch (DistributionException e) {
            this.log.error("an error happened during dispatching items to the queue(s)", e);
            distributionResponses.add(new SimpleDistributionResponse(DistributionRequestState.DROPPED, e.toString()));
        }
        return distributionResponses;
    }

    private DistributionRequestState getRequestStateFromQueueState(DistributionQueueItemState itemState) {
        DistributionRequestState requestState;
        switch (itemState) {
            case QUEUED: {
                requestState = DistributionRequestState.ACCEPTED;
                break;
            }
            case ERROR: {
                requestState = DistributionRequestState.DROPPED;
                break;
            }
            default: {
                requestState = DistributionRequestState.DROPPED;
            }
        }
        return requestState;
    }
}

