/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl.resource;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueType;
import org.apache.sling.distribution.queue.impl.DistributionQueueProcessor;
import org.apache.sling.distribution.queue.impl.DistributionQueueProvider;
import org.apache.sling.distribution.queue.impl.resource.ActiveResourceQueue;
import org.apache.sling.distribution.queue.impl.resource.ResourceQueue;
import org.apache.sling.distribution.queue.impl.resource.ResourceQueueCleanupTask;
import org.apache.sling.distribution.queue.impl.simple.SimpleDistributionQueueProcessor;
import org.apache.sling.distribution.queue.spi.DistributionQueue;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceQueueProvider
implements DistributionQueueProvider {
    public static final String TYPE = "resource";
    public static final String QUEUES_ROOT = "/var/sling/distribution/queues/";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ResourceResolverFactory resolverFactory;
    private String serviceName;
    private String agentRootPath;
    private Scheduler scheduler;
    private String agentName;
    private boolean isActive;
    private final Map<String, ResourceQueue> queueMap = new ConcurrentHashMap<String, ResourceQueue>();
    private ServiceRegistration<Runnable> cleanupTask;

    public ResourceQueueProvider(BundleContext context, ResourceResolverFactory resolverFactory, String serviceName, String agentName, Scheduler scheduler, boolean isActive) {
        if (serviceName == null || scheduler == null && isActive || context == null || resolverFactory == null || agentName == null) {
            throw new IllegalArgumentException("all arguments are required");
        }
        this.resolverFactory = resolverFactory;
        this.serviceName = serviceName;
        this.agentName = agentName;
        this.agentRootPath = QUEUES_ROOT + agentName;
        this.scheduler = scheduler;
        this.isActive = isActive;
        this.register(context);
    }

    @Override
    @NotNull
    public DistributionQueue getQueue(@NotNull String queueName) throws DistributionException {
        return this.queueMap.computeIfAbsent(queueName, name -> {
            if (this.isActive) {
                return new ActiveResourceQueue(this.resolverFactory, this.serviceName, (String)name, this.agentRootPath);
            }
            return new ResourceQueue(this.resolverFactory, this.serviceName, (String)name, this.agentRootPath);
        });
    }

    @Override
    @NotNull
    public DistributionQueue getQueue(@NotNull String queueName, @NotNull DistributionQueueType type) {
        try {
            return this.getQueue(queueName);
        }
        catch (DistributionException e) {
            throw new RuntimeException("could not create config for queue " + queueName, e);
        }
    }

    @Override
    public void enableQueueProcessing(@NotNull DistributionQueueProcessor queueProcessor, String ... queueNames) throws DistributionException {
        if (this.isActive) {
            for (String queueName : queueNames) {
                ScheduleOptions options = this.scheduler.NOW(-1, 1L).canRunConcurrently(false).onSingleInstanceOnly(true).name(this.getJobName(queueName));
                DistributionQueue queueImpl = this.getQueue(queueName);
                Consumer<DistributionQueueEntry> processingAttemptRecorder = null;
                if (this.isActive) {
                    processingAttemptRecorder = ((ActiveResourceQueue)queueImpl)::recordProcessingAttempt;
                }
                this.scheduler.schedule((Object)new SimpleDistributionQueueProcessor(queueImpl, queueProcessor, processingAttemptRecorder), options);
            }
        } else {
            throw new DistributionException(new UnsupportedOperationException("enable Processing not supported for Passive Queues"));
        }
    }

    @Override
    public void disableQueueProcessing() throws DistributionException {
        if (this.isActive) {
            for (DistributionQueue distributionQueue : this.queueMap.values()) {
                String queueName = distributionQueue.getName();
                if (this.scheduler.unschedule(this.getJobName(queueName))) {
                    this.log.debug("queue processing on {} stopped", (Object)distributionQueue);
                    continue;
                }
                this.log.warn("could not disable queue processing on {}", (Object)distributionQueue);
            }
        } else {
            throw new DistributionException(new UnsupportedOperationException("disable Processing not supported for Passive Queues"));
        }
    }

    private String getJobName(String queueName) {
        return "resource-queueProcessor-" + this.agentName + "-" + queueName;
    }

    private void register(BundleContext context) {
        ResourceQueueCleanupTask cleanup = new ResourceQueueCleanupTask(this.resolverFactory, this.serviceName, this.agentRootPath);
        Hashtable<String, Comparable<Boolean>> props = new Hashtable<String, Comparable<Boolean>>();
        ((Dictionary)props).put("scheduler.concurrent", false);
        ((Dictionary)props).put("scheduler.period", 300L);
        this.cleanupTask = context.registerService(Runnable.class, (Object)cleanup, props);
    }

    public void close() {
        if (this.cleanupTask != null) {
            this.cleanupTask.unregister();
            this.cleanupTask = null;
        }
    }
}

