/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.servlet;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.distribution.agent.spi.DistributionAgent;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.distribution.packaging.impl.DistributionPackageBuilderProvider;
import org.apache.sling.distribution.packaging.impl.DistributionPackageUtils;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.spi.DistributionQueue;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@SlingServletResourceTypes(methods={"POST"}, resourceTypes={"sling/distribution/service/agent/queue"})
public class DistributionAgentQueueServlet
extends SlingAllMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference
    private DistributionPackageBuilderProvider packageBuilderProvider;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String operation = request.getParameter("operation");
        DistributionQueue queue = (DistributionQueue)request.getResource().adaptTo(DistributionQueue.class);
        ResourceResolver resourceResolver = request.getResourceResolver();
        if ("delete".equals(operation)) {
            String limitParam = request.getParameter("limit");
            String[] idParam = request.getParameterValues("id");
            if (idParam != null) {
                this.assertCapability(queue, "removable");
                this.deleteItems(resourceResolver, queue, new HashSet<String>(Arrays.asList(idParam)));
            } else {
                int limit = 1;
                try {
                    limit = Integer.parseInt(limitParam);
                }
                catch (NumberFormatException ex) {
                    this.log.warn("limit param malformed : " + limitParam, (Throwable)ex);
                }
                this.assertCapability(queue, "clearable");
                this.clearItems(resourceResolver, queue, limit);
            }
        } else if ("copy".equals(operation)) {
            String from = request.getParameter("from");
            String[] idParam = request.getParameterValues("id");
            if (idParam != null && from != null) {
                this.assertCapability(queue, "appendable");
                DistributionAgent agent = (DistributionAgent)request.getResource().getParent().getParent().adaptTo(DistributionAgent.class);
                DistributionQueue sourceQueue = DistributionAgentQueueServlet.getQueueOrThrow(agent, from);
                this.addItems(resourceResolver, queue, sourceQueue, idParam);
            }
        } else if ("move".equals(operation)) {
            String from = request.getParameter("from");
            String[] idParam = request.getParameterValues("id");
            if (idParam != null && from != null) {
                this.assertCapability(queue, "appendable");
                DistributionAgent agent = (DistributionAgent)request.getResource().getParent().getParent().adaptTo(DistributionAgent.class);
                DistributionQueue sourceQueue = DistributionAgentQueueServlet.getQueueOrThrow(agent, from);
                this.assertCapability(sourceQueue, "removable");
                this.addItems(resourceResolver, queue, sourceQueue, idParam);
                this.deleteItems(resourceResolver, sourceQueue, new HashSet<String>(Arrays.asList(idParam)));
            }
        }
    }

    private void addItems(ResourceResolver resourceResolver, DistributionQueue targetQueue, DistributionQueue sourceQueue, String[] ids) {
        for (String id : ids) {
            DistributionQueueEntry entry = sourceQueue.getEntry(id);
            if (entry == null) continue;
            targetQueue.add(entry.getItem());
            DistributionPackage distributionPackage = this.getPackage(resourceResolver, entry.getItem());
            DistributionPackageUtils.acquire(distributionPackage, targetQueue.getName());
        }
    }

    private void deleteItems(ResourceResolver resourceResolver, DistributionQueue queue, Set<String> entryIds) {
        for (DistributionQueueEntry removed : queue.remove(entryIds)) {
            this.releaseOrDeletePackage(resourceResolver, removed.getItem(), queue.getName());
        }
    }

    private void clearItems(ResourceResolver resourceResolver, DistributionQueue queue, int limit) {
        for (DistributionQueueEntry removed : queue.clear(limit)) {
            this.releaseOrDeletePackage(resourceResolver, removed.getItem(), queue.getName());
        }
    }

    private void releaseOrDeletePackage(ResourceResolver resourceResolver, DistributionQueueItem queueItem, String queueName) {
        DistributionPackage distributionPackage = this.getPackage(resourceResolver, queueItem);
        DistributionPackageUtils.releaseOrDelete(distributionPackage, queueName);
    }

    private DistributionPackage getPackage(ResourceResolver resourceResolver, DistributionQueueItem item) {
        DistributionPackageInfo info = DistributionPackageUtils.fromQueueItem(item);
        String type = info.getType();
        DistributionPackageBuilder packageBuilder = this.packageBuilderProvider.getPackageBuilder(type);
        if (packageBuilder != null) {
            try {
                return packageBuilder.getPackage(resourceResolver, item.getPackageId());
            }
            catch (DistributionException e) {
                this.log.error("cannot get package", (Throwable)e);
            }
        }
        return null;
    }

    private void assertCapability(DistributionQueue queue, String capability) {
        if (!queue.hasCapability(capability)) {
            throw new UnsupportedOperationException(String.format("Capability %s not supported for queue %s", capability, queue.getName()));
        }
    }

    @NotNull
    private static DistributionQueue getQueueOrThrow(@NotNull DistributionAgent agent, @NotNull String queueName) {
        DistributionQueue queue = agent.getQueue(queueName);
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Could not find queue %s", queueName));
        }
        return queue;
    }
}

