/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.graphql.api.SlingDataFetcher;
import org.apache.sling.graphql.core.osgi.ServiceReferenceObjectTuple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SlingDataFetcherSelector.class})
public class SlingDataFetcherSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlingDataFetcherSelector.class);
    static final Pattern FETCHER_NAME_PATTERN = Pattern.compile("\\w+(/\\w+)+");
    private final Map<String, TreeSet<ServiceReferenceObjectTuple<SlingDataFetcher<Object>>>> dataFetchers = new HashMap<String, TreeSet<ServiceReferenceObjectTuple<SlingDataFetcher<Object>>>>();
    public static final String RESERVED_NAME_PREFIX = "sling/";
    public static final String RESERVED_PACKAGE_PREFIX = "org.apache.sling.";

    @Nullable
    public SlingDataFetcher<Object> getSlingFetcher(@NotNull String name) {
        SlingDataFetcher<Object> result = this.getOsgiServiceFetcher(name);
        return result;
    }

    private SlingDataFetcher<Object> getOsgiServiceFetcher(@NotNull String name) {
        TreeSet<ServiceReferenceObjectTuple<SlingDataFetcher<Object>>> fetcherSet = this.dataFetchers.get(name);
        if (fetcherSet != null && !fetcherSet.isEmpty()) {
            return fetcherSet.last().getServiceObject();
        }
        return null;
    }

    private boolean hasValidName(@NotNull ServiceReference<SlingDataFetcher<Object>> serviceReference, @NotNull SlingDataFetcher<Object> fetcher) {
        String name = PropertiesUtil.toString((Object)serviceReference.getProperty("name"), null);
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            if (!SlingDataFetcherSelector.nameMatchesPattern(name)) {
                LOGGER.error("Invalid SlingDataFetcher {}: fetcher name is not namespaced (e.g. ns/myFetcher)", (Object)fetcher.getClass().getName());
                return false;
            }
            if (name.startsWith(RESERVED_NAME_PREFIX)) {
                String className = fetcher.getClass().getName();
                if (!fetcher.getClass().getName().startsWith(RESERVED_PACKAGE_PREFIX)) {
                    LOGGER.error("Invalid SlingDataFetcher {}: fetcher names starting with '{}' are reserved for Apache Sling Java packages", (Object)className, (Object)RESERVED_NAME_PREFIX);
                    return false;
                }
            }
        } else {
            LOGGER.error("Invalid {} implementation: fetcher {} is missing the mandatory value for its {} service property.", new Object[]{SlingDataFetcher.class.getName(), fetcher.getClass().getName(), "name"});
            return false;
        }
        return true;
    }

    static boolean nameMatchesPattern(String name) {
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            return FETCHER_NAME_PATTERN.matcher(name).matches();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=SlingDataFetcher.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private void bindSlingDataFetcher(ServiceReference<SlingDataFetcher<Object>> reference, SlingDataFetcher<Object> slingDataFetcher) {
        if (this.hasValidName(reference, slingDataFetcher)) {
            Map<String, TreeSet<ServiceReferenceObjectTuple<SlingDataFetcher<Object>>>> map = this.dataFetchers;
            synchronized (map) {
                String name = (String)reference.getProperty("name");
                TreeSet fetchers = this.dataFetchers.computeIfAbsent(name, key -> new TreeSet());
                fetchers.add(new ServiceReferenceObjectTuple<SlingDataFetcher<Object>>(reference, slingDataFetcher));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindSlingDataFetcher(ServiceReference<SlingDataFetcher<Object>> reference) {
        Map<String, TreeSet<ServiceReferenceObjectTuple<SlingDataFetcher<Object>>>> map = this.dataFetchers;
        synchronized (map) {
            TreeSet<ServiceReferenceObjectTuple<SlingDataFetcher<Object>>> fetchers;
            String name = (String)reference.getProperty("name");
            if (StringUtils.isNotEmpty((CharSequence)name) && (fetchers = this.dataFetchers.get(name)) != null) {
                Optional<ServiceReferenceObjectTuple> tupleToRemove = fetchers.stream().filter(tuple -> reference.equals(tuple.getServiceReference())).findFirst();
                tupleToRemove.ifPresent(fetchers::remove);
            }
        }
    }
}

