/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl.servlet.junit5;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sling.junit.TestSelector;
import org.apache.sling.junit.impl.TestExecutionStrategy;
import org.apache.sling.junit.impl.TestsManagerImpl;
import org.apache.sling.junit.impl.servlet.junit5.JUnitPlatformHelper;
import org.apache.sling.junit.impl.servlet.junit5.RunListenerAdapter;
import org.apache.sling.junit.impl.servlet.junit5.TestEngineTracker;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.runner.notification.RunListener;
import org.osgi.framework.BundleContext;

public class JUnit5TestExecutionStrategy
implements TestExecutionStrategy {
    private static final List<String> REQUIRED_CLASSES = Collections.unmodifiableList(Arrays.asList("org.junit.platform.engine.TestEngine", "org.junit.platform.launcher.Launcher"));
    private final TestsManagerImpl testsManager;
    private final TestEngineTracker testEngineTracker;

    public static boolean canLoadRequiredClasses() {
        ClassLoader classLoader = JUnit5TestExecutionStrategy.class.getClassLoader();
        return REQUIRED_CLASSES.stream().allMatch(name -> {
            String path = name.replace('.', '/').concat(".class");
            return classLoader.getResource(path) != null;
        });
    }

    public JUnit5TestExecutionStrategy(TestsManagerImpl testsManager, BundleContext ctx) {
        this.testsManager = testsManager;
        this.testEngineTracker = new TestEngineTracker(ctx);
    }

    @Override
    public void close() {
        this.testEngineTracker.close();
    }

    @Override
    public void execute(TestSelector selector, RunListener runListener) throws Exception {
        Launcher launcher = JUnitPlatformHelper.createLauncher(this.testEngineTracker.getAvailableTestEngines());
        LauncherDiscoveryRequest request = this.testsManager.createTestRequest(selector, JUnitPlatformHelper::methodRequest, JUnitPlatformHelper::classesRequest);
        launcher.execute(request, new TestExecutionListener[]{new RunListenerAdapter(runListener)});
    }
}

