/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.console.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.apache.sling.scripting.console.internal.RuntimeScriptResource;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service
@Property(name="felix.webconsole.label", value={"scriptconsole"})
public class ScriptConsolePlugin
extends SimpleWebConsolePlugin {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String NAME = "scriptconsole";
    private static final String TITLE = "%script.title";
    private static final String[] CSS = new String[]{"/res/ui/codemirror/lib/codemirror.css", "/res/ui/script-console.css"};
    private final String TEMPLATE = this.readTemplateFile("/templates/script-console.html");
    private BundleContext bundleContext;
    @Reference
    private ScriptEngineManager scriptEngineManager;

    public ScriptConsolePlugin() {
        super(NAME, TITLE, ScriptConsolePlugin.processFileNames(CSS));
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        DefaultVariableResolver varResolver = (DefaultVariableResolver)WebConsoleUtil.getVariableResolver((ServletRequest)request);
        varResolver.put((Object)"__scriptConfig__", (Object)this.getScriptConfig());
        pw.println(this.TEMPLATE);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String contentType = this.getContentType(req);
        resp.setContentType(contentType);
        if (contentType.startsWith("text/")) {
            resp.setCharacterEncoding("UTF-8");
        }
        String script = this.getCodeValue(req);
        SlingBindings bindings = new SlingBindings();
        PrintWriter pw = resp.getWriter();
        bindings.put((Object)"request", (Object)req);
        bindings.put((Object)"reader", (Object)new StringReader(script));
        bindings.put((Object)"response", (Object)resp);
        bindings.put((Object)"out", (Object)pw);
        bindings.put((Object)"bundleContext", (Object)this.bundleContext);
        String lang = WebConsoleUtil.getParameter((HttpServletRequest)req, (String)"lang");
        RuntimeScriptResource resource = new RuntimeScriptResource(lang, script);
        boolean webClient = "webconsole".equals(WebConsoleUtil.getParameter((HttpServletRequest)req, (String)"client"));
        SlingScript slingScript = (SlingScript)resource.adaptTo(SlingScript.class);
        try {
            this.log.debug("Executing script {}", (Object)script);
            slingScript.eval(bindings);
        }
        catch (Throwable t) {
            if (!webClient) {
                resp.setStatus(500);
            }
            pw.println(this.exceptionToString(t));
            this.log.warn("Error in executing script", t);
        }
    }

    private String getCodeValue(HttpServletRequest req) throws IOException {
        String script = WebConsoleUtil.getParameter((HttpServletRequest)req, (String)"code");
        if (script == null) {
            script = this.getContentFromFilePart(req, "code");
        }
        if (script == null) {
            throw new IllegalArgumentException("'code' parameter not passed");
        }
        return script;
    }

    private String getContentType(HttpServletRequest req) {
        String passedContentType = WebConsoleUtil.getParameter((HttpServletRequest)req, (String)"responseContentType");
        if (passedContentType != null) {
            return passedContentType;
        }
        return req.getPathInfo().endsWith(".json") ? "application/json" : "text/plain";
    }

    private String exceptionToString(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private static String[] processFileNames(String[] cssFiles) {
        String[] css = new String[cssFiles.length];
        for (int i = 0; i < cssFiles.length; ++i) {
            css[i] = "/scriptconsole" + CSS[i];
        }
        return css;
    }

    private String getScriptConfig() {
        try {
            return this.getScriptConfig0();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private String getScriptConfig0() throws JSONException {
        StringWriter sw = new StringWriter();
        JSONWriter jw = new JSONWriter((Writer)sw);
        jw.setTidy(true);
        jw.array();
        for (ScriptEngineFactory sef : this.scriptEngineManager.getEngineFactories()) {
            jw.object();
            if (sef.getExtensions().isEmpty()) continue;
            jw.key("langName").value((Object)sef.getLanguageName());
            jw.key("langCode").value((Object)sef.getExtensions().get(0));
            String mode = this.determineMode(sef.getExtensions());
            if (mode != null) {
                jw.key("mode").value((Object)mode);
            }
            jw.endObject();
        }
        jw.endArray();
        return sw.toString();
    }

    private String determineMode(List<String> extensions) {
        if (extensions.contains("groovy")) {
            return "groovy";
        }
        if (extensions.contains("esp")) {
            return "javascript";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContentFromFilePart(HttpServletRequest req, String paramName) throws IOException {
        String string;
        String value = WebConsoleUtil.getParameter((HttpServletRequest)req, (String)paramName);
        if (value != null) {
            return value;
        }
        Map params = (Map)req.getAttribute("org.apache.felix.webconsole.fileupload");
        if (params == null) {
            return null;
        }
        FileItem[] codeFile = this.getFileItems(params, paramName);
        if (codeFile.length == 0) {
            return null;
        }
        InputStream is = null;
        try {
            is = codeFile[0].getInputStream();
            StringWriter sw = new StringWriter();
            IOUtils.copy((InputStream)is, (Writer)sw, (String)"utf-8");
            string = sw.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return string;
    }

    private FileItem[] getFileItems(Map params, String name) {
        ArrayList<FileItem> files = new ArrayList<FileItem>();
        FileItem[] items = (FileItem[])params.get(name);
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                if (items[i].isFormField() || items[i].getSize() <= 0L) continue;
                files.add(items[i]);
            }
        }
        return files.toArray(new FileItem[files.size()]);
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
        this.bundleContext = bundleContext;
    }

    @Deactivate
    public void deactivate() {
        super.deactivate();
    }

    protected void bindScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    protected void unbindScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        if (this.scriptEngineManager == scriptEngineManager) {
            this.scriptEngineManager = null;
        }
    }
}

