/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.java.compiler.impl.operator;

import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.NodeVisitor;
import org.apache.sling.scripting.sightly.compiler.expression.SideEffectVisitor;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator;
import org.apache.sling.scripting.sightly.java.compiler.impl.ExpressionTranslator;
import org.apache.sling.scripting.sightly.java.compiler.impl.JavaSource;
import org.apache.sling.scripting.sightly.java.compiler.impl.Type;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.BinaryOpGen;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.OpHelper;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.TypedNode;

public class ComparisonOpGen
implements BinaryOpGen {
    private final String javaOperator;
    private final boolean inverted;
    private final String runtimeMethod;
    private static final String METHOD_LEQ = "leq";
    private static final String METHOD_LT = "lt";
    private static final String OBJECT_NAME = BinaryOperator.class.getName();

    public ComparisonOpGen(BinaryOperator operator) {
        switch (operator) {
            case LT: {
                this.runtimeMethod = METHOD_LT;
                this.inverted = false;
                this.javaOperator = "<";
                break;
            }
            case GT: {
                this.runtimeMethod = METHOD_LEQ;
                this.inverted = true;
                this.javaOperator = ">";
                break;
            }
            case LEQ: {
                this.runtimeMethod = METHOD_LEQ;
                this.inverted = false;
                this.javaOperator = "<=";
                break;
            }
            case GEQ: {
                this.runtimeMethod = METHOD_LT;
                this.inverted = true;
                this.javaOperator = ">=";
                break;
            }
            default: {
                throw new IllegalArgumentException("Operator is not a comparison operator: " + operator);
            }
        }
    }

    @Override
    public Type returnType(Type left, Type right) {
        return Type.BOOLEAN;
    }

    @Override
    public void generate(JavaSource source, ExpressionTranslator visitor, TypedNode left, TypedNode right) {
        Type type = OpHelper.sameType(left, right);
        if (OpHelper.isNumericType(type)) {
            this.generateWithOperator(source, visitor, left.getNode(), right.getNode());
        } else {
            this.generateGeneric(source, visitor, left.getNode(), right.getNode());
        }
    }

    private void generateGeneric(JavaSource source, SideEffectVisitor visitor, ExpressionNode leftNode, ExpressionNode rightNode) {
        if (this.inverted) {
            source.negation().startExpression();
        }
        source.startMethodCall(OBJECT_NAME, this.runtimeMethod);
        leftNode.accept((NodeVisitor)visitor);
        source.separateArgument();
        rightNode.accept((NodeVisitor)visitor);
        source.endCall();
        if (this.inverted) {
            source.endExpression();
        }
    }

    private void generateWithOperator(JavaSource source, SideEffectVisitor visitor, ExpressionNode leftNode, ExpressionNode rightNode) {
        leftNode.accept((NodeVisitor)visitor);
        source.append(" ").append(this.javaOperator).append(" ");
        rightNode.accept((NodeVisitor)visitor);
    }
}

