/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.js.impl;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.LazyBindings;
import org.apache.sling.scripting.api.resource.ScriptingResourceResolverProvider;
import org.apache.sling.scripting.core.ScriptNameAwareReader;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.js.impl.JsEnvironment;
import org.apache.sling.scripting.sightly.js.impl.Utils;
import org.apache.sling.scripting.sightly.js.impl.async.AsyncContainer;
import org.apache.sling.scripting.sightly.js.impl.async.AsyncExtractor;
import org.apache.sling.scripting.sightly.js.impl.jsapi.ProxyAsyncScriptableFactory;
import org.apache.sling.scripting.sightly.js.impl.rhino.JsValueAdapter;
import org.apache.sling.scripting.sightly.js.impl.use.DependencyResolver;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.use.ProviderOutcome;
import org.apache.sling.scripting.sightly.use.UseProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;

@Component(service={UseProvider.class}, configurationPid={"org.apache.sling.scripting.sightly.js.impl.JsUseProvider"}, property={"service.ranking:Integer=80"})
public class JsUseProvider
implements UseProvider {
    private static final String JS_ENGINE_NAME = "rhino";
    private static final JsValueAdapter jsValueAdapter = new JsValueAdapter(new AsyncExtractor());
    @Reference
    private ScriptEngineManager scriptEngineManager;
    @Reference
    private ProxyAsyncScriptableFactory proxyAsyncScriptableFactory;
    @Reference
    private ScriptingResourceResolverProvider scriptingResourceResolverProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProviderOutcome provide(String identifier, RenderContext renderContext, Bindings arguments) {
        LazyBindings globalBindings = new LazyBindings();
        globalBindings.putAll(renderContext.getBindings());
        if (!Utils.isJsScript(identifier)) {
            return ProviderOutcome.failure();
        }
        ScriptEngine jsEngine = this.scriptEngineManager.getEngineByName(JS_ENGINE_NAME);
        if (jsEngine == null) {
            return ProviderOutcome.failure((Throwable)new SightlyException("Failed to obtain a rhino JavaScript engine."));
        }
        JsEnvironment environment = null;
        try {
            ResourceResolver slingScriptingResolver = this.scriptingResourceResolverProvider.getRequestScopedResourceResolver();
            DependencyResolver dependencyResolver = new DependencyResolver(slingScriptingResolver);
            environment = new JsEnvironment(jsEngine, dependencyResolver);
            environment.initialize();
            ScriptNameAwareReader reader = dependencyResolver.resolve((Bindings)globalBindings, identifier);
            if (reader != null) {
                this.proxyAsyncScriptableFactory.registerProxies(slingScriptingResolver, environment, (Bindings)globalBindings);
                AsyncContainer asyncContainer = environment.runScript(reader, (Bindings)globalBindings, arguments);
                ProviderOutcome providerOutcome = ProviderOutcome.success((Object)jsValueAdapter.adapt(asyncContainer));
                return providerOutcome;
            }
            ProviderOutcome providerOutcome = ProviderOutcome.failure();
            return providerOutcome;
        }
        catch (Exception e) {
            ProviderOutcome providerOutcome = ProviderOutcome.failure((Throwable)e);
            return providerOutcome;
        }
        finally {
            if (environment != null) {
                environment.cleanup();
            }
        }
    }

    static @interface Configuration {
        @AttributeDefinition(name="Service Ranking", description="The Service Ranking value acts as the priority with which this Use Provider is queried to return an Use-object. A higher value represents a higher priority.")
        public int service_ranking() default 80;
    }
}

