/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.superimposing.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.superimposing.SuperimposingManager;
import org.apache.sling.superimposing.SuperimposingResourceProvider;
import org.apache.sling.superimposing.impl.SuperimposingResourceProviderImpl;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(label="Apache Sling Superimposing Resource Manager", description="Manages the resource registrations for the Superimposing Resource Provider.", immediate=true, metatype=true)
@Service(value={SuperimposingManager.class})
public class SuperimposingManagerImpl
implements SuperimposingManager,
EventListener {
    @Property(label="Enabled", description="Enable/Disable the superimposing functionality.", boolValue={false})
    static final String ENABLED_PROPERTY = "enabled";
    static final boolean ENABLED_DEFAULT = false;
    private boolean enabled;
    @Property(label="Find all Queries", description="List of query expressions to find all existing superimposing registrations on service startup. Query syntax is depending on underlying resource provdider implementation. Prepend the query with query syntax name separated by \"|\".", value={"JCR-SQL2|SELECT * FROM [sling:Superimpose] WHERE ISDESCENDANTNODE('/content')"}, unbounded=PropertyUnbounded.ARRAY)
    static final String FINDALLQUERIES_PROPERTY = "findAllQueries";
    static final String FINDALLQUERIES_DEFAULT = "JCR-SQL2|SELECT * FROM [sling:Superimpose] WHERE ISDESCENDANTNODE('/content')";
    private String[] findAllQueries;
    @Property(label="Obervation paths", description="List of paths that should be monitored for resource events to detect superimposing content nodes.", value={"/content"}, unbounded=PropertyUnbounded.ARRAY)
    static final String OBSERVATION_PATHS_PROPERTY = "obervationPaths";
    static final String OBSERVATION_PATHS_DEFAULT = "/content";
    private String[] obervationPaths;
    private EventListener[] observationEventListeners;
    private ConcurrentMap<String, SuperimposingResourceProviderImpl> superimposingProviders = new ConcurrentHashMap<String, SuperimposingResourceProviderImpl>();
    @Reference
    private ResourceResolverFactory resolverFactory;
    private ResourceResolver resolver;
    Future<?> initialization;
    private BundleContext bundleContext;
    private static final Logger log = LoggerFactory.getLogger(SuperimposingManagerImpl.class);

    private List<Resource> findSuperimposings(ResourceResolver resolver) {
        ArrayList<Resource> allResources = new ArrayList<Resource>();
        for (String queryString : this.findAllQueries) {
            if (!StringUtils.contains((String)queryString, (String)"|")) {
                throw new IllegalArgumentException("Query string does not contain query syntax seperated by '|': " + queryString);
            }
            String queryLanguage = StringUtils.substringBefore((String)queryString, (String)"|");
            String query = StringUtils.substringAfter((String)queryString, (String)"|");
            allResources.addAll(IteratorUtils.toList((Iterator)resolver.findResources(query, queryLanguage)));
        }
        return allResources;
    }

    private void registerAllSuperimposings() {
        log.debug("Start registering all superimposing trees...");
        long start = System.currentTimeMillis();
        long countSuccess = 0L;
        long countFailed = 0L;
        List<Resource> existingSuperimposings = this.findSuperimposings(this.resolver);
        for (Resource superimposingResource : existingSuperimposings) {
            boolean success = this.registerProvider(superimposingResource);
            if (success) {
                ++countSuccess;
                continue;
            }
            ++countFailed;
        }
        long time = System.currentTimeMillis() - start;
        log.info("Registered {} SuperimposingResourceProvider(s) in {} ms, skipping {} invalid one(s).", new Object[]{countSuccess, time, countFailed});
    }

    private boolean registerProvider(Resource superimposingResource) {
        String superimposePath = superimposingResource.getPath();
        String sourcePath = this.getJcrStringProperty(superimposePath, "sling:superimposeSourcePath");
        boolean registerParent = this.getJcrBooleanProperty(superimposePath, "sling:superimposeRegisterParent");
        boolean overlayable = this.getJcrBooleanProperty(superimposePath, "sling:superimposeOverlayable");
        boolean valid = true;
        if (StringUtils.isBlank((String)sourcePath)) {
            valid = false;
        } else {
            if (registerParent) {
                superimposePath = ResourceUtil.getParent((String)superimposePath);
            }
            if (StringUtils.equals((String)sourcePath, (String)superimposePath) || StringUtils.startsWith((String)sourcePath, (String)(superimposePath + "/")) || StringUtils.startsWith((String)superimposePath, (String)(sourcePath + "/"))) {
                valid = false;
            }
        }
        if (valid) {
            SuperimposingResourceProviderImpl srp = new SuperimposingResourceProviderImpl(superimposePath, sourcePath, overlayable);
            SuperimposingResourceProviderImpl oldSrp = this.superimposingProviders.put(superimposePath, srp);
            if (!srp.equals(oldSrp)) {
                log.debug("(Re-)registering resource provider {}.", (Object)superimposePath);
                if (null != oldSrp) {
                    oldSrp.unregisterService();
                }
                srp.registerService(this.bundleContext);
                return true;
            }
            log.debug("Skipped re-registering resource provider {} because there were no relevant changes.", (Object)superimposePath);
        } else {
            SuperimposingResourceProviderImpl oldSrp = (SuperimposingResourceProviderImpl)this.superimposingProviders.remove(superimposePath);
            if (null != oldSrp) {
                log.debug("Unregistering resource provider {}.", (Object)superimposePath);
                oldSrp.unregisterService();
            }
            log.warn("Superimposing definition '{}' pointing to '{}' is invalid.", (Object)superimposePath, (Object)sourcePath);
        }
        return false;
    }

    private String getJcrStringProperty(String pNodePath, String pPropertName) {
        String absolutePropertyPath = pNodePath + "/" + pPropertName;
        Session session = (Session)this.resolver.adaptTo(Session.class);
        try {
            if (!session.itemExists(absolutePropertyPath)) {
                return null;
            }
            return session.getProperty(absolutePropertyPath).getString();
        }
        catch (RepositoryException ex) {
            return null;
        }
    }

    private boolean getJcrBooleanProperty(String pNodePath, String pPropertName) {
        String absolutePropertyPath = pNodePath + "/" + pPropertName;
        Session session = (Session)this.resolver.adaptTo(Session.class);
        try {
            if (!session.itemExists(absolutePropertyPath)) {
                return false;
            }
            return session.getProperty(absolutePropertyPath).getBoolean();
        }
        catch (RepositoryException ex) {
            return false;
        }
    }

    private void registerProvider(String path) {
        Resource provider = this.resolver.getResource(path);
        if (provider != null) {
            this.registerProvider(provider);
        }
    }

    private void unregisterProvider(String path) {
        SuperimposingResourceProviderImpl srp = (SuperimposingResourceProviderImpl)this.superimposingProviders.remove(path);
        if (null != srp) {
            srp.unregisterService();
        }
    }

    @Activate
    protected synchronized void activate(ComponentContext ctx) throws LoginException, RepositoryException {
        Dictionary props = ctx.getProperties();
        this.enabled = PropertiesUtil.toBoolean(props.get(ENABLED_PROPERTY), (boolean)false);
        log.debug("Config: Enabled={} ", (Object)this.enabled);
        if (!this.isEnabled()) {
            return;
        }
        this.findAllQueries = PropertiesUtil.toStringArray(props.get(FINDALLQUERIES_PROPERTY), (String[])new String[]{FINDALLQUERIES_DEFAULT});
        this.obervationPaths = PropertiesUtil.toStringArray(props.get(OBSERVATION_PATHS_PROPERTY), (String[])new String[]{OBSERVATION_PATHS_DEFAULT});
        if (null == this.resolver) {
            this.bundleContext = ctx.getBundleContext();
            this.resolver = this.resolverFactory.getAdministrativeResourceResolver(null);
            Session session = (Session)this.resolver.adaptTo(Session.class);
            if (session != null) {
                this.observationEventListeners = new EventListener[this.obervationPaths.length];
                for (int i = 0; i < this.obervationPaths.length; ++i) {
                    this.observationEventListeners[i] = new EventListener(){

                        public void onEvent(EventIterator events) {
                            SuperimposingManagerImpl.this.onEvent(events);
                        }
                    };
                    session.getWorkspace().getObservationManager().addEventListener(this.observationEventListeners[i], 31, this.obervationPaths[i], true, null, null, true);
                }
            }
            this.initialization = Executors.newSingleThreadExecutor().submit(new Runnable(){

                public void run() {
                    try {
                        SuperimposingManagerImpl.this.registerAllSuperimposings();
                    }
                    catch (Throwable ex) {
                        log.warn("Error registering existing superimposing resources on service startup.", ex);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected synchronized void deactivate(ComponentContext ctx) throws RepositoryException {
        try {
            Session session;
            if (null != this.initialization && !this.initialization.isDone()) {
                this.initialization.cancel(true);
            }
            if (this.resolver != null && (session = (Session)this.resolver.adaptTo(Session.class)) != null && this.observationEventListeners != null) {
                for (EventListener eventListener : this.observationEventListeners) {
                    session.getWorkspace().getObservationManager().removeEventListener(eventListener);
                }
            }
            for (SuperimposingResourceProviderImpl srp : this.superimposingProviders.values()) {
                srp.unregisterService();
            }
        }
        finally {
            if (null != this.resolver) {
                this.resolver.close();
                this.resolver = null;
            }
            this.initialization = null;
            this.superimposingProviders.clear();
        }
    }

    public void onEvent(EventIterator events) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            HashMap<String, Boolean> actions = new HashMap<String, Boolean>();
            boolean nodeAdded = false;
            boolean nodeRemoved = false;
            while (events.hasNext()) {
                Event event = events.nextEvent();
                String path = event.getPath();
                String name = ResourceUtil.getName((String)path);
                if (event.getType() == 1) {
                    nodeAdded = true;
                    continue;
                }
                if (event.getType() == 2 && this.superimposingProviders.containsKey(path)) {
                    nodeRemoved = true;
                    actions.put(path, false);
                    continue;
                }
                if (!StringUtils.equals((String)name, (String)"sling:superimposeSourcePath") && !StringUtils.equals((String)name, (String)"sling:superimposeRegisterParent") && !StringUtils.equals((String)name, (String)"sling:superimposeOverlayable")) continue;
                String nodePath = ResourceUtil.getParent((String)path);
                actions.put(nodePath, true);
            }
            for (Map.Entry action : actions.entrySet()) {
                if (((Boolean)action.getValue()).booleanValue()) {
                    this.registerProvider((String)action.getKey());
                    continue;
                }
                this.unregisterProvider((String)action.getKey());
            }
            if (nodeAdded && nodeRemoved) {
                this.registerAllSuperimposings();
            }
        }
        catch (RepositoryException e) {
            log.error("Unexpected repository exception during event processing.");
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Iterator<SuperimposingResourceProvider> getRegisteredProviders() {
        return IteratorUtils.unmodifiableIterator(this.superimposingProviders.values().iterator());
    }

    SuperimposingManagerImpl withResourceResolverFactory(ResourceResolverFactory resolverFactory) {
        this.resolverFactory = resolverFactory;
        return this;
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }
}

