/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.resource;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import org.apache.sysds.resource.CloudInstance;
import org.apache.sysds.resource.enumeration.EnumerationUtils;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONObject;

public class CloudUtils {
    public static final double JVM_MEMORY_FACTOR = 0.9;
    public static final String EC2_REGEX = "^([a-z]+)([0-9])(a|g|i?)([bdnez]*)\\.([a-z0-9]+)$";
    public static final int EBS_DEFAULT_ROOT_SIZE_EMR = 15;
    public static final int EBS_DEFAULT_ROOT_SIZE_EC2 = 8;
    public static final String SPARK_VERSION = "3.3.0";
    public static final double MINIMAL_EXECUTION_TIME = 300.0;
    public static final double DEFAULT_CLUSTER_LAUNCH_TIME = 300.0;
    private static CloudProvider provider = CloudProvider.AWS;

    public static void setProvider(CloudProvider provider) {
        CloudUtils.provider = provider;
    }

    private CloudUtils() {
    }

    public static long GBtoBytes(double gb) {
        return (long)(gb * 1024.0 * 1024.0 * 1024.0);
    }

    public static boolean validateInstanceName(String instanceName) {
        instanceName = instanceName.toLowerCase();
        if (provider == CloudProvider.AWS && !instanceName.toLowerCase().matches(EC2_REGEX)) {
            return false;
        }
        try {
            CloudUtils.getInstanceFamily(instanceName);
            CloudUtils.getInstanceSize(instanceName);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static InstanceFamily getInstanceFamily(String instanceName) {
        String familyAsString = instanceName.split("\\.")[0];
        return InstanceFamily.customValueOf(familyAsString);
    }

    public static InstanceSize getInstanceSize(String instanceName) {
        String sizeAsString = instanceName.split("\\.")[1];
        return InstanceSize.customValueOf(sizeAsString);
    }

    public static double calculateClusterPrice(EnumerationUtils.ConfigurationPoint config, double time, CloudProvider provider) {
        double pricePerSecond;
        if (provider == CloudProvider.AWS) {
            if (config.numberExecutors == 0) {
                CloudInstance singleNode = config.driverInstance;
                pricePerSecond = singleNode.getPrice() + singleNode.getExtraStoragePrice() / 2.0;
            } else {
                CloudInstance masterNode = config.driverInstance;
                CloudInstance coreNode = config.executorInstance;
                pricePerSecond = masterNode.getPrice() + masterNode.getExtraFee() + masterNode.getExtraStoragePrice();
                pricePerSecond += (double)config.numberExecutors * (coreNode.getPrice() + coreNode.getExtraFee() + coreNode.getExtraStoragePrice());
            }
        } else {
            throw new IllegalArgumentException("AWS is the only cloud provider supported at the moment");
        }
        return time * pricePerSecond;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double[] loadRegionalPrices(String feeTablePath, String region) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(feeTablePath));){
            String parsedLine = br.readLine();
            if (!parsedLine.equals("Region,Fee Ratio,EBS Price")) {
                throw new IOException("Fee Table: invalid CSV header: " + parsedLine);
            }
            while ((parsedLine = br.readLine()) != null) {
                String[] values = parsedLine.split(",");
                if (values.length != 3) {
                    throw new IOException(String.format("Fee Table: invalid CSV line '%s' inside: %s", parsedLine, feeTablePath));
                }
                if (!region.equals(values[0])) continue;
                double[] dArray = new double[]{Double.parseDouble(values[1]), Double.parseDouble(values[2])};
                return dArray;
            }
            throw new IOException(String.format("Fee Table: region '%s' not found in the CSV table: %s", region, feeTablePath));
        }
        catch (FileNotFoundException e) {
            throw new RemoteException(feeTablePath + " read failed: " + e);
        }
    }

    public static HashMap<String, CloudInstance> loadInstanceInfoTable(String instanceTablePath, double emrFeeRatio, double ebsStoragePrice) throws IOException {
        HashMap<String, CloudInstance> hashMap;
        HashMap<String, CloudInstance> result = new HashMap<String, CloudInstance>();
        int lineCount = 1;
        BufferedReader br = new BufferedReader(new FileReader(instanceTablePath));
        try {
            String parsedLine = br.readLine();
            if (!parsedLine.equals("API_Name,Price,Memory,vCPUs,Cores,GFLOPS,memBandwidth,NVMe,storageVolumes,sizePerVolume,readStorageBandwidth,writeStorageBandwidth,networkBandwidth")) {
                throw new IOException("Instance info table: invalid CSV header inside: " + instanceTablePath);
            }
            while ((parsedLine = br.readLine()) != null) {
                String[] values = parsedLine.split(",");
                if (values.length != 13 || !CloudUtils.validateInstanceName(values[0])) {
                    throw new IOException(String.format("Instance info table: invalid CSV line(%d) inside: %s, instance of type %s", lineCount, instanceTablePath, values[0]));
                }
                String name = values[0];
                double price = Double.parseDouble(values[1]);
                double extraFee = price * emrFeeRatio;
                long memory = CloudUtils.GBtoBytes(Double.parseDouble(values[2]));
                int vCPUs = Integer.parseInt(values[3]);
                double GFlops = Double.parseDouble(values[5]);
                double memBandwidth = Double.parseDouble(values[6]);
                double diskReadBandwidth = Double.parseDouble(values[10]);
                double diskWriteBandwidth = Double.parseDouble(values[11]);
                double networkBandwidth = Double.parseDouble(values[12]);
                boolean NVMeStorage = Boolean.parseBoolean(values[7]);
                int numberStorageVolumes = Integer.parseInt(values[8]);
                double sizeStorageVolumes = Double.parseDouble(values[9]);
                CloudInstance parsedInstance = new CloudInstance(name, price, extraFee, ebsStoragePrice, memory, vCPUs, GFlops, memBandwidth, diskReadBandwidth, diskWriteBandwidth, networkBandwidth, NVMeStorage, numberStorageVolumes, sizeStorageVolumes);
                result.put(name, parsedInstance);
                ++lineCount;
            }
            hashMap = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new IOException("Read failed", ex);
            }
        }
        br.close();
        return hashMap;
    }

    public static void generateEC2ConfigJson(CloudInstance instance, String filePath) {
        try {
            JSONObject ec2Config = new JSONObject();
            ec2Config.put("InstanceType", (Object)instance.getInstanceName());
            int ebsRootSize = 8;
            if (!instance.isNVMeStorage()) {
                ebsRootSize += (int)Math.ceil((double)instance.getNumStorageVolumes() * instance.getSizeStoragePerVolume() / 2.0);
            }
            ec2Config.put("VolumeSize", ebsRootSize);
            ec2Config.put("VolumeType", (Object)"gp3");
            ec2Config.put("EbsOptimized", true);
            int cpMemory = (int)((double)(instance.getMemory() / 0x100000L) * 0.9);
            ec2Config.put("JvmMaxMemory", cpMemory);
            try (FileWriter file = new FileWriter(filePath);){
                file.write(ec2Config.write(true));
                System.out.println("EC2 configuration JSON file: " + filePath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void generateEMRInstanceGroupsJson(EnumerationUtils.ConfigurationPoint clusterConfig, String filePath) {
        try {
            JSONArray instanceGroups = new JSONArray();
            JSONObject masterGroup = new JSONObject();
            masterGroup.put("InstanceCount", 1);
            masterGroup.put("InstanceGroupType", (Object)"MASTER");
            masterGroup.put("InstanceType", (Object)clusterConfig.driverInstance.getInstanceName());
            masterGroup.put("Name", (Object)"Master Instance Group");
            CloudUtils.attachEBSConfigsIfNeeded(clusterConfig.driverInstance, masterGroup);
            instanceGroups.add(masterGroup);
            JSONObject coreGroup = new JSONObject();
            coreGroup.put("InstanceCount", clusterConfig.numberExecutors);
            coreGroup.put("InstanceGroupType", (Object)"CORE");
            coreGroup.put("InstanceType", (Object)clusterConfig.executorInstance.getInstanceName());
            coreGroup.put("Name", (Object)"Core Instance Group");
            CloudUtils.attachEBSConfigsIfNeeded(clusterConfig.executorInstance, coreGroup);
            instanceGroups.add(coreGroup);
            try (FileWriter file = new FileWriter(filePath);){
                file.write(instanceGroups.write(true));
                System.out.println("Instance Groups JSON file created: " + filePath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void attachEBSConfigsIfNeeded(CloudInstance instance, JSONObject instanceGroup) {
        if (!instance.isNVMeStorage()) {
            try {
                JSONObject volumeSpecification = new JSONObject();
                volumeSpecification.put("SizeInGB", (int)instance.getSizeStoragePerVolume());
                volumeSpecification.put("VolumeType", (Object)"gp3");
                JSONObject ebsBlockDeviceConfig = new JSONObject();
                ebsBlockDeviceConfig.put("VolumesPerInstance", instance.getNumStorageVolumes());
                ebsBlockDeviceConfig.put("VolumeSpecification", volumeSpecification);
                JSONArray ebsBlockDeviceConfigsArray = new JSONArray();
                ebsBlockDeviceConfigsArray.add(ebsBlockDeviceConfig);
                JSONObject ebsConfiguration = new JSONObject();
                ebsConfiguration.put("EbsOptimized", true);
                ebsConfiguration.put("EbsBlockDeviceConfigs", ebsBlockDeviceConfigsArray);
                instanceGroup.put("EbsConfiguration", ebsConfiguration);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void generateEMRConfigurationsJson(EnumerationUtils.ConfigurationPoint clusterConfig, String filePath) {
        try {
            JSONArray configurations = new JSONArray();
            JSONObject sparkConfig = new JSONObject();
            sparkConfig.put("Classification", (Object)"spark");
            sparkConfig.put("Properties", new JSONObject().put("maximizeResourceAllocation", (Object)"false"));
            JSONObject sparkDefaultsConfig = new JSONObject();
            sparkDefaultsConfig.put("Classification", (Object)"spark-defaults");
            JSONObject sparkDefaultsProperties = new JSONObject();
            long driverMemoryBytes = CloudUtils.calculateEffectiveDriverMemoryBudget(clusterConfig.driverInstance.getMemory(), clusterConfig.numberExecutors * clusterConfig.executorInstance.getVCPUs());
            int driverMemory = (int)(driverMemoryBytes / 0x100000L);
            sparkDefaultsProperties.put("spark.driver.memory", (Object)(driverMemory + "m"));
            sparkDefaultsProperties.put("spark.driver.maxResultSize", (Object)String.valueOf(0));
            int[] executorResources = CloudUtils.getEffectiveExecutorResources(clusterConfig.executorInstance.getMemory(), clusterConfig.executorInstance.getVCPUs(), clusterConfig.numberExecutors);
            sparkDefaultsProperties.put("spark.executor.memory", (Object)(executorResources[0] + "m"));
            sparkDefaultsProperties.put("spark.executor.cores", (Object)Integer.toString(executorResources[1]));
            sparkDefaultsProperties.put("spark.executor.instances", (Object)Integer.toString(executorResources[2]));
            sparkDefaultsProperties.put("spark.storage.memoryFraction", (Object)String.valueOf(0.6));
            sparkDefaultsProperties.put("spark.memory.storageFraction", (Object)String.valueOf(0.5));
            sparkDefaultsProperties.put("spark.executor.memoryOverheadFactor", (Object)String.valueOf(0.1));
            sparkDefaultsProperties.put("spark.yarn.am.memory", (Object)(executorResources[3] + "m"));
            sparkDefaultsProperties.put("spark.yarn.am.cores", (Object)Integer.toString(executorResources[4]));
            sparkDefaultsConfig.put("Properties", sparkDefaultsProperties);
            JSONObject sparkEnvConfig = new JSONObject();
            sparkEnvConfig.put("Classification", (Object)"spark-env");
            JSONObject jvmVersion = new JSONObject().put("JAVA_HOME", (Object)"/usr/lib/jvm/jre-11");
            JSONObject exportConfig = new JSONObject();
            exportConfig.put("Classification", (Object)"export");
            exportConfig.put("Properties", jvmVersion);
            JSONArray jvmArray = new JSONArray();
            jvmArray.add(exportConfig);
            sparkEnvConfig.put("Configurations", jvmArray);
            configurations.add(sparkConfig);
            configurations.add(sparkDefaultsConfig);
            configurations.add(sparkEnvConfig);
            try (FileWriter file = new FileWriter(filePath);){
                file.write(configurations.write(true));
                System.out.println("Configurations JSON file created: " + filePath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int[] getEffectiveExecutorResources(long memory, int cores, int numExecutors) {
        int effectiveNumExecutors;
        int effectiveAmCores;
        int effectiveAmMemoryMB;
        int effectiveExecutorCores;
        int effectiveExecutorMemoryMB;
        long yarnAllocationMemory = (long)((double)memory * 0.75);
        int totalExecutorCores = cores * numExecutors;
        int amMemoryMB = CloudUtils.calculateAmMemoryMB(totalExecutorCores);
        int amMemoryOverheadMB = Math.max(384, (int)((double)amMemoryMB * 0.1));
        long amTotalMemory = (long)(amMemoryMB + amMemoryOverheadMB) * 1024L * 1024L;
        int amCores = CloudUtils.calculateAmCores(totalExecutorCores);
        if (amTotalMemory * (long)numExecutors >= yarnAllocationMemory) {
            effectiveExecutorMemoryMB = (int)Math.floor((double)yarnAllocationMemory / 1153433.6);
            effectiveExecutorCores = cores;
            effectiveAmMemoryMB = effectiveExecutorMemoryMB;
            effectiveAmCores = cores;
            effectiveNumExecutors = numExecutors - 1;
        } else {
            effectiveExecutorMemoryMB = (int)Math.floor((double)(yarnAllocationMemory - amTotalMemory) / 1153433.6);
            effectiveExecutorCores = cores - amCores;
            effectiveAmMemoryMB = amMemoryMB;
            effectiveAmCores = amCores;
            effectiveNumExecutors = numExecutors;
        }
        return new int[]{effectiveExecutorMemoryMB, effectiveExecutorCores, effectiveNumExecutors, effectiveAmMemoryMB, effectiveAmCores};
    }

    public static int calculateAmMemoryMB(int totalExecutorCores) {
        return 512 + (int)Math.floor((double)totalExecutorCores / 16.0) * 256;
    }

    public static int calculateAmCores(int totalExecutorCores) {
        int scaledCores = (int)Math.ceil((double)totalExecutorCores / 64.0);
        return Math.min(8, scaledCores);
    }

    public static long calculateEffectiveDriverMemoryBudget(long driverMemory, int totalExecutorCores) {
        int effectiveBudgetMB = 1024 + (int)Math.floor((double)totalExecutorCores / 16.0) * 256;
        long effectiveBudgetBytes = (long)effectiveBudgetMB * 1024L * 1024L;
        return Math.min((long)((double)driverMemory * 0.9), driverMemory - effectiveBudgetBytes);
    }

    public static enum InstanceSize {
        _XLARGE,
        _2XLARGE,
        _3XLARGE,
        _4XLARGE,
        _6XLARGE,
        _8XLARGE,
        _9XLARGE,
        _12XLARGE,
        _16XLARGE,
        _18XLARGE,
        _24XLARGE,
        _32XLARGE,
        _48XLARGE;


        public static InstanceSize customValueOf(String name) throws IllegalArgumentException {
            return InstanceSize.valueOf("_" + name.toUpperCase());
        }
    }

    public static enum InstanceFamily {
        M5,
        M5A,
        M6I,
        M6A,
        M6G,
        M7I,
        M7A,
        M7G,
        M5D,
        M5AD,
        M6ID,
        M6GD,
        M7GD,
        M5N,
        M6IN,
        M5DN,
        M6IDN,
        M5ZN,
        C5,
        C5A,
        C6I,
        C6A,
        C6G,
        C7I,
        C7A,
        C7G,
        C5D,
        C5AD,
        C6ID,
        C6GD,
        C7GD,
        C5N,
        C6IN,
        C6GN,
        C7GN,
        R5,
        R5A,
        R6I,
        R6A,
        R6G,
        R7I,
        R7A,
        R7G,
        R5D,
        R5AD,
        R6ID,
        R6AD,
        R6GD,
        R7ID,
        R7AD,
        R7GD,
        R5N,
        R5DN,
        R6IN,
        R6IDN;


        public static InstanceFamily customValueOf(String name) {
            return InstanceFamily.valueOf(name.toUpperCase());
        }
    }

    public static enum CloudProvider {
        AWS;

    }
}

