/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.insertionsort;

import org.apache.sysds.runtime.compress.colgroup.insertionsort.AInsertionSorter;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public class MaterializeSort
extends AInsertionSorter {
    public static int CACHE_BLOCK = 16000;
    private final AMapToData md = MapToFactory.create(Math.min(this._numRows, CACHE_BLOCK), this._numLabels + 1);
    private final int[] skip;
    private int off = 0;

    protected MaterializeSort(int endLength, int numRows, IntArrayList[] offsets) {
        super(endLength, numRows, offsets);
        this.skip = new int[offsets.length];
        for (int block = 0; block < this._numRows; block += CACHE_BLOCK) {
            this.insert(block, Math.min(block + CACHE_BLOCK, this._numRows));
        }
    }

    protected MaterializeSort(int endLength, int numRows, IntArrayList[] offsets, int negativeIndex) {
        super(endLength, numRows, offsets, negativeIndex);
        this.skip = new int[offsets.length];
        for (int block = 0; block < this._numRows; block += CACHE_BLOCK) {
            this.insertWithNegative(block, Math.min(block + CACHE_BLOCK, this._numRows));
        }
    }

    private void insert(int rl, int ru) {
        this.md.fill(this._numLabels);
        this.materializeInsert(rl, ru);
        this.filterInsert(rl, ru);
    }

    private void materializeInsert(int rl, int ru) {
        for (int i = 0; i < this._offsets.length; ++i) {
            IntArrayList of = this._offsets[i];
            int size = of.size();
            int k = this.skip[i];
            while (k < size && of.get(k) < ru) {
                this.md.set(of.get(k++) - rl, i);
            }
            this.skip[i] = k;
        }
    }

    private void filterInsert(int rl, int ru) {
        int len = ru - rl;
        for (int i = 0; i < len; ++i) {
            int idx = this.md.getIndex(i);
            if (idx == this._numLabels) continue;
            this.set(this.off++, i + rl, idx);
        }
    }

    private void insertWithNegative(int rl, int ru) {
        int i;
        this.md.fill(this._numLabels);
        for (i = 0; i < this._offsets.length; ++i) {
            IntArrayList of = this._offsets[i];
            int k = this.skip[i];
            while (k < of.size() && of.get(k) < ru) {
                this.md.set(of.get(k++) - rl, i);
            }
            this.skip[i] = k;
        }
        for (i = rl; i < ru; ++i) {
            int idx = this.md.getIndex(i - rl);
            if (idx < this._negativeIndex) {
                this.set(this.off++, i, idx);
                continue;
            }
            if (idx <= this._negativeIndex) continue;
            this.set(this.off++, i, idx - 1);
        }
    }
}

