/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.codegen;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.hops.codegen.SpoofCompiler;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.codegen.ByteClassLoader;
import org.apache.sysds.runtime.codegen.SpoofOperator;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.LocalFileUtils;
import org.apache.sysds.utils.stats.CodegenStatistics;
import org.codehaus.janino.SimpleCompiler;

public class CodegenUtils {
    private static final Log LOG = LogFactory.getLog((String)CodegenUtils.class.getName());
    private static ConcurrentHashMap<String, Class<?>> _cache = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> _src = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Integer> _CUDA_op_IDs = new ConcurrentHashMap();
    private static ConcurrentHashMap<Integer, String> _CUDA_op_src = new ConcurrentHashMap();
    private static String _workingDir = null;
    public static ClassLoader _mainClassLoader = null;

    public static synchronized void setClassLoader(ClassLoader clsLoader) {
        _mainClassLoader = clsLoader;
    }

    public static Class<?> compileClass(String name, String src) {
        Class<?> ret = _cache.get(name);
        if (ret != null) {
            return ret;
        }
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        ret = SpoofCompiler.JAVA_COMPILER == SpoofCompiler.CompilerType.JANINO ? CodegenUtils.compileClassJanino(name, src) : CodegenUtils.compileClassJavac(name, src);
        _cache.put(name, ret);
        if (DMLScript.STATISTICS) {
            CodegenStatistics.incrementClassCompile();
            CodegenStatistics.incrementClassCompileTime(System.nanoTime() - t0);
        }
        return ret;
    }

    public static Class<?> getClass(String name) {
        return CodegenUtils.getClass(name, null);
    }

    public static synchronized Class<?> getClassSync(String name, byte[] classBytes) {
        return CodegenUtils.getClass(name, classBytes);
    }

    public static Class<?> getClass(String name, byte[] classBytes) {
        Class<?> ret = _cache.get(name);
        if (ret != null) {
            return ret;
        }
        ret = SpoofCompiler.JAVA_COMPILER == SpoofCompiler.CompilerType.JANINO ? CodegenUtils.compileClassJanino(name, new String(classBytes)) : CodegenUtils.loadFromClassFile(name, classBytes);
        _cache.put(name, ret);
        return ret;
    }

    public static byte[] getClassData(String name) {
        if (SpoofCompiler.JAVA_COMPILER == SpoofCompiler.CompilerType.JANINO) {
            return _src.get(name).getBytes();
        }
        return CodegenUtils.getClassAsByteArray(name);
    }

    public static void clearClassCache() {
        _cache.clear();
        _src.clear();
    }

    public static void clearClassCache(Class<?> cla) {
        Iterator<Map.Entry<String, Class<?>>> iter = _cache.entrySet().iterator();
        while (iter.hasNext()) {
            if (iter.next().getValue() != cla) continue;
            iter.remove();
        }
    }

    public static SpoofOperator createInstance(Class<?> cla) {
        SpoofOperator ret = null;
        try {
            ret = (SpoofOperator)cla.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return ret;
    }

    public static Integer getCUDAopID(String name) {
        return _CUDA_op_IDs.get(name);
    }

    public static void putCUDAOpID(String name, int id) {
        _CUDA_op_IDs.put(name, id);
    }

    public static void putCUDASource(int id, String src) {
        _CUDA_op_src.put(id, src);
    }

    public static SpoofOperator.SideInput createSideInput(MatrixBlock in) {
        SpoofOperator.SideInput ret = in.isInSparseFormat() || !in.isAllocated() ? new SpoofOperator.SideInput(null, in, in.getNumColumns()) : new SpoofOperator.SideInput(in.getDenseBlock(), null, in.getNumColumns());
        return ret.mdat != null ? new SpoofOperator.SideInputSparseCell(ret) : ret;
    }

    private static synchronized Class<?> compileClassJanino(String name, String src) {
        try {
            SimpleCompiler compiler = new SimpleCompiler();
            if (_mainClassLoader != null) {
                compiler.setParentClassLoader(_mainClassLoader);
            }
            compiler.cook(src);
            _src.put(name, src);
            return compiler.getClassLoader().loadClass(name);
        }
        catch (Exception ex) {
            LOG.error((Object)("Failed to compile class " + name + ": \n" + src));
            throw new DMLRuntimeException("Failed to compile class " + name + ".", ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Class<?> compileClassJavac(String name, String src) {
        try {
            File ftmp;
            if (_workingDir == null) {
                CodegenUtils.createWorkingDir();
            }
            if (!(ftmp = new File(_workingDir + "/" + name.replace(".", "/") + ".java")).getParentFile().exists()) {
                ftmp.getParentFile().mkdirs();
            }
            LocalFileUtils.writeTextFile(ftmp, src);
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            if (compiler == null) {
                throw new RuntimeException("Unable to obtain system java compiler.");
            }
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);){
                Class<?> clazz;
                Iterable<? extends JavaFileObject> sources = fileManager.getJavaFileObjectsFromFiles(Arrays.asList(ftmp));
                URL runDir = CodegenUtils.class.getProtectionDomain().getCodeSource().getLocation();
                String classpath = System.getProperty("java.class.path") + File.pathSeparator + runDir.getPath();
                List<String> options = Arrays.asList("-classpath", classpath);
                JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, options, null, sources);
                Boolean success = task.call();
                for (Diagnostic tmp : diagnostics.getDiagnostics()) {
                    if (tmp.getKind() != Diagnostic.Kind.ERROR) continue;
                    System.err.println("ERROR: " + tmp.toString());
                }
                if (success == null || !success.booleanValue()) {
                    throw new RuntimeException("Failed to compile class " + name);
                }
                try (URLClassLoader classLoader = new URLClassLoader(new URL[]{new File(_workingDir).toURI().toURL(), runDir}, CodegenUtils.class.getClassLoader());){
                    clazz = classLoader.loadClass(name);
                }
                return clazz;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Failed to compile class " + name + ": \n" + src));
            throw new DMLRuntimeException("Failed to compile class " + name + ".", ex);
        }
    }

    private static Class<?> loadFromClassFile(String name, byte[] classBytes) {
        Class<?> clazz;
        if (classBytes != null) {
            Class<?> clazz2;
            ByteClassLoader byteLoader = new ByteClassLoader(new URL[0], CodegenUtils.class.getClassLoader(), classBytes);
            try {
                clazz2 = byteLoader.findClass(name);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        byteLoader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DMLRuntimeException(e);
                }
            }
            byteLoader.close();
            return clazz2;
        }
        URL runDir = CodegenUtils.class.getProtectionDomain().getCodeSource().getLocation();
        URLClassLoader classLoader = new URLClassLoader(new URL[]{new File(_workingDir).toURI().toURL(), runDir}, CodegenUtils.class.getClassLoader());
        try {
            clazz = classLoader.loadClass(name);
        }
        catch (Throwable throwable) {
            try {
                try {
                    classLoader.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
        }
        classLoader.close();
        return clazz;
    }

    private static byte[] getClassAsByteArray(String name) {
        byte[] byArray;
        String classAsPath = name.replace('.', '/') + ".class";
        URLClassLoader classLoader = null;
        InputStream stream = null;
        try {
            URL runDir = CodegenUtils.class.getProtectionDomain().getCodeSource().getLocation();
            classLoader = new URLClassLoader(new URL[]{new File(_workingDir).toURI().toURL(), runDir}, CodegenUtils.class.getClassLoader());
            stream = classLoader.getResourceAsStream(classAsPath);
            byArray = IOUtils.toByteArray((InputStream)stream);
        }
        catch (IOException e) {
            try {
                throw new DMLRuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtilFunctions.closeSilently(classLoader);
                IOUtilFunctions.closeSilently(stream);
                throw throwable;
            }
        }
        IOUtilFunctions.closeSilently(classLoader);
        IOUtilFunctions.closeSilently(stream);
        return byArray;
    }

    private static void createWorkingDir() {
        if (_workingDir != null) {
            return;
        }
        String tmp = LocalFileUtils.getWorkingDir("codegen");
        LocalFileUtils.createLocalFileIfNotExist(tmp);
        _workingDir = tmp;
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i)) || str.charAt(i) == '-' && i == 0) continue;
            return false;
        }
        return true;
    }

    public static String printWithLineNumber(String src) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        Scanner scanner = new Scanner(src);
        int line_count = 0;
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            sb.append(line_count++ + ": " + line + System.lineSeparator());
        }
        scanner.close();
        return sb.toString();
    }
}

