/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark.utils;

import java.io.Serializable;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import scala.Tuple2;
import scala.Tuple5;

public class FrameRDDAggregateUtils {
    public static Tuple2<Boolean, Integer> checkRowAlignment(JavaPairRDD<Long, FrameBlock> in, int blen) {
        JavaRDD row_rdd = in.map((Function & Serializable)in1 -> {
            long key = (Long)in1._1();
            FrameBlock blk = (FrameBlock)in1._2();
            return new Tuple5((Object)true, (Object)key, (Object)(blen == -1 ? blk.getNumRows() : blen), (Object)blk.getNumRows(), (Object)true);
        });
        Tuple5 result = row_rdd.fold(null, (Function2 & Serializable)(in1, in2) -> {
            boolean min_index_comp;
            if (in1 == null) {
                return in2;
            }
            if (in2 == null) {
                return in1;
            }
            if (!((Boolean)in1._1()).booleanValue()) {
                return in1;
            }
            if (!((Boolean)in2._1()).booleanValue()) {
                return in2;
            }
            int in1_max = (Integer)in1._3();
            int in1_min = (Integer)in1._4();
            long in1_min_index = (Long)in1._2();
            int in2_max = (Integer)in2._3();
            int in2_min = (Integer)in2._4();
            long in2_min_index = (Long)in2._2();
            boolean in1_isSingleBlock = (Boolean)in1._5();
            boolean in2_isSingleBlock = (Boolean)in2._5();
            boolean bl = min_index_comp = in1_min_index > in2_min_index;
            if (in1_max == in2_max) {
                if (in1_min == in1_max) {
                    if (in2_min == in2_max) {
                        return new Tuple5((Object)true, (Object)(min_index_comp ? in1_min_index : in2_min_index), (Object)in1_max, (Object)in1_max, (Object)false);
                    }
                    if (!min_index_comp) {
                        return new Tuple5((Object)true, (Object)in2_min_index, (Object)in1_max, (Object)in2_min, (Object)false);
                    }
                } else if (in2_min == in2_max && min_index_comp) {
                    return new Tuple5((Object)true, (Object)in1_min_index, (Object)in1_max, (Object)in1_min, (Object)false);
                }
            } else {
                if (in1_max > in2_max && in1_min == in1_max && in2_isSingleBlock && in1_min_index < in2_min_index) {
                    return new Tuple5((Object)true, (Object)in2_min_index, (Object)in1_max, (Object)in2_min, (Object)false);
                }
                if (in1_max < in2_max && in2_min == in2_max && in1_isSingleBlock && in2_min_index < in1_min_index) {
                    return new Tuple5((Object)true, (Object)in1_min_index, (Object)in2_max, (Object)in1_min, (Object)false);
                }
            }
            return new Tuple5((Object)false, null, null, null, null);
        });
        return new Tuple2((Object)((Boolean)result._1()), (Object)((Integer)result._3()));
    }

    public static JavaPairRDD<Long, FrameBlock> mergeByKey(JavaPairRDD<Long, FrameBlock> in) {
        return in.combineByKey(new CreateBlockCombinerFunction(), new MergeBlocksFunction(false), new MergeBlocksFunction(false));
    }

    private static class MergeBlocksFunction
    implements Function2<FrameBlock, FrameBlock, FrameBlock> {
        private static final long serialVersionUID = 7807210434431147007L;
        private boolean _deep = false;

        public MergeBlocksFunction(boolean deep) {
            this._deep = deep;
        }

        public FrameBlock call(FrameBlock b1, FrameBlock b2) throws Exception {
            if (b1.getNumRows() != b2.getNumRows() || b1.getNumColumns() != b2.getNumColumns()) {
                throw new DMLRuntimeException("Mismatched frame block sizes for: " + b1.getNumRows() + " " + b1.getNumColumns() + " " + b2.getNumRows() + " " + b2.getNumColumns());
            }
            FrameBlock ret = this._deep ? new FrameBlock(b1) : b1;
            ret.merge(b2);
            return ret;
        }
    }

    private static class CreateBlockCombinerFunction
    implements Function<FrameBlock, FrameBlock> {
        private static final long serialVersionUID = -4445167244905540494L;

        private CreateBlockCombinerFunction() {
        }

        public FrameBlock call(FrameBlock arg0) throws Exception {
            return new FrameBlock(arg0);
        }
    }
}

