/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.io.FrameReaderBinaryBlock;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.util.CommonThreadPool;

public class FrameReaderBinaryBlockParallel
extends FrameReaderBinaryBlock {
    @Override
    protected void readBinaryBlockFrameFromHDFS(Path path, JobConf job, FileSystem fs, FrameBlock dest, long rlen, long clen) throws IOException, DMLRuntimeException {
        int numThreads = OptimizerUtils.getParallelBinaryReadParallelism();
        ExecutorService pool = CommonThreadPool.get(numThreads);
        try {
            ArrayList<ReadFileTask> tasks = new ArrayList<ReadFileTask>();
            for (Path lpath : IOUtilFunctions.getSequenceFilePaths(fs, path)) {
                tasks.add(new ReadFileTask(lpath, job, fs, dest));
            }
            for (Future future : pool.invokeAll(tasks)) {
                future.get();
            }
        }
        catch (Exception e) {
            throw new IOException("Failed parallel read of binary block input.", e);
        }
        finally {
            pool.shutdown();
        }
    }

    private class ReadFileTask
    implements Callable<Object> {
        private Path _path = null;
        private JobConf _job = null;
        private FileSystem _fs = null;
        private FrameBlock _dest = null;

        public ReadFileTask(Path path, JobConf job, FileSystem fs, FrameBlock dest) {
            this._path = path;
            this._fs = fs;
            this._job = job;
            this._dest = dest;
        }

        @Override
        public Object call() throws Exception {
            FrameReaderBinaryBlock.readBinaryBlockFrameFromSequenceFile(this._path, this._job, this._fs, this._dest);
            return null;
        }
    }
}

