/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.util.data;

import java.io.Serializable;
import org.ascape.util.data.DataPoint;
import org.ascape.util.data.ValueNotInRangeException;

public abstract class UnitIntervalDataPoint
implements DataPoint,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name = "Unnamed";

    public UnitIntervalDataPoint() {
    }

    public UnitIntervalDataPoint(String name) {
        this.name = name;
    }

    public abstract double getValue(Object var1);

    public String getName() {
        return this.name;
    }

    public double getBracketedValue(Object object) {
        return Math.min(Math.max(this.getValue(object), 0.0), 1.0);
    }

    public double getAssertedValue(Object object) throws ValueNotInRangeException {
        double value = this.getValue(object);
        if (value < 0.0 || value > 1.0) {
            throw new ValueNotInRangeException("Unit interval value outside of asserted range (0.0 - 1.0): " + value);
        }
        return value;
    }
}

