/*******************************************************************************
 * Copyright (c) 2012-2016 Codenvy, S.A.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Codenvy, S.A. - initial API and implementation
 *******************************************************************************/


// GENERATED SOURCE. DO NOT EDIT.
package org.eclipse.che.api.user.server.dto;

import org.eclipse.che.dto.server.JsonSerializable;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;

import java.util.List;
import java.util.Map;


@SuppressWarnings({"unchecked", "cast"})
public class DtoServerImpls implements org.eclipse.che.dto.server.DtoFactoryVisitor {

  private static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();

  @Override
  public void accept(org.eclipse.che.dto.server.DtoFactory dtoFactory) {
    dtoFactory.registerProvider(org.eclipse.che.api.user.shared.dto.MembershipDto.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.api.user.shared.dto.MembershipDto>() {
        public Class<? extends org.eclipse.che.api.user.shared.dto.MembershipDto> getImplClass() {
            return MembershipDtoImpl.class;
        }

        public org.eclipse.che.api.user.shared.dto.MembershipDto newInstance() {
            return MembershipDtoImpl.make();
        }

        public org.eclipse.che.api.user.shared.dto.MembershipDto fromJson(String json) {
            return MembershipDtoImpl.fromJsonString(json);
        }

        public org.eclipse.che.api.user.shared.dto.MembershipDto fromJson(com.google.gson.JsonElement json) {
            return MembershipDtoImpl.fromJsonElement(json);
        }

        public org.eclipse.che.api.user.shared.dto.MembershipDto clone(org.eclipse.che.api.user.shared.dto.MembershipDto origin) {
            return new MembershipDtoImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.api.user.shared.dto.ProfileDescriptor.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.api.user.shared.dto.ProfileDescriptor>() {
        public Class<? extends org.eclipse.che.api.user.shared.dto.ProfileDescriptor> getImplClass() {
            return ProfileDescriptorImpl.class;
        }

        public org.eclipse.che.api.user.shared.dto.ProfileDescriptor newInstance() {
            return ProfileDescriptorImpl.make();
        }

        public org.eclipse.che.api.user.shared.dto.ProfileDescriptor fromJson(String json) {
            return ProfileDescriptorImpl.fromJsonString(json);
        }

        public org.eclipse.che.api.user.shared.dto.ProfileDescriptor fromJson(com.google.gson.JsonElement json) {
            return ProfileDescriptorImpl.fromJsonElement(json);
        }

        public org.eclipse.che.api.user.shared.dto.ProfileDescriptor clone(org.eclipse.che.api.user.shared.dto.ProfileDescriptor origin) {
            return new ProfileDescriptorImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.api.user.shared.dto.UserDescriptor.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.api.user.shared.dto.UserDescriptor>() {
        public Class<? extends org.eclipse.che.api.user.shared.dto.UserDescriptor> getImplClass() {
            return UserDescriptorImpl.class;
        }

        public org.eclipse.che.api.user.shared.dto.UserDescriptor newInstance() {
            return UserDescriptorImpl.make();
        }

        public org.eclipse.che.api.user.shared.dto.UserDescriptor fromJson(String json) {
            return UserDescriptorImpl.fromJsonString(json);
        }

        public org.eclipse.che.api.user.shared.dto.UserDescriptor fromJson(com.google.gson.JsonElement json) {
            return UserDescriptorImpl.fromJsonElement(json);
        }

        public org.eclipse.che.api.user.shared.dto.UserDescriptor clone(org.eclipse.che.api.user.shared.dto.UserDescriptor origin) {
            return new UserDescriptorImpl(origin);
        }
    });
  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class MembershipDtoImpl implements org.eclipse.che.api.user.shared.dto.MembershipDto, JsonSerializable  {

    public static MembershipDtoImpl make() {
        return new MembershipDtoImpl();
    }

    public MembershipDtoImpl() {
    }

    protected java.lang.String subjectId;
    protected java.lang.String userName;
    protected java.lang.String scope;
    protected java.lang.String userId;
    protected java.util.List<java.lang.String> roles;
    protected java.util.Map<java.lang.String, java.lang.String> subjectProperties;

    @Override
    public java.lang.String getSubjectId() {
      return subjectId;
    }

    public void setSubjectId(java.lang.String v) {
      this.subjectId = v;
    }

    @Override
    public java.lang.String getUserName() {
      return userName;
    }

    public void setUserName(java.lang.String v) {
      this.userName = v;
    }

    @Override
    public java.lang.String getScope() {
      return scope;
    }

    public void setScope(java.lang.String v) {
      this.scope = v;
    }

    @Override
    public java.lang.String getUserId() {
      return userId;
    }

    public void setUserId(java.lang.String v) {
      this.userId = v;
    }

    @Override
    public java.util.List<java.lang.String> getRoles() {
      ensureRoles();
      return new org.eclipse.che.dto.server.JsonArrayImpl(roles);
    }

    public void setRoles(java.util.List<java.lang.String> v) {
      this.roles = v;
    }

    public void addRoles(java.lang.String v) {
      ensureRoles();
      roles.add(v);
    }

    public void clearRoles() {
      ensureRoles();
      roles.clear();
    }

    protected void ensureRoles() {
      if (roles == null) {
        roles = new java.util.ArrayList<java.lang.String>();
      }
    }
    @Override
    public java.util.Map<java.lang.String, java.lang.String> getSubjectProperties() {
      ensureSubjectProperties();
      return new org.eclipse.che.dto.server.JsonStringMapImpl(subjectProperties);
    }

    public void setSubjectProperties(java.util.Map<java.lang.String, java.lang.String> v) {
      this.subjectProperties = v;
    }

    public void putSubjectProperties(String k, java.lang.String v) {
      ensureSubjectProperties();
      subjectProperties.put(k, v);
    }

    public void clearSubjectProperties() {
      ensureSubjectProperties();
      subjectProperties.clear();
    }

    protected void ensureSubjectProperties() {
      if (subjectProperties == null) {
        subjectProperties = new java.util.HashMap<java.lang.String, java.lang.String>();
      }
    }
    @Override
    public boolean equals(Object o) {
      if (!(o instanceof MembershipDtoImpl)) {
        return false;
      }
      MembershipDtoImpl other = (MembershipDtoImpl) o;
      if (this.subjectId != null) {
        if (!this.subjectId.equals(other.subjectId)) {
          return false;
        }
      } else {
        if (other.subjectId != null) {
          return false;
        }
      }
      if (this.userName != null) {
        if (!this.userName.equals(other.userName)) {
          return false;
        }
      } else {
        if (other.userName != null) {
          return false;
        }
      }
      if (this.scope != null) {
        if (!this.scope.equals(other.scope)) {
          return false;
        }
      } else {
        if (other.scope != null) {
          return false;
        }
      }
      if (this.userId != null) {
        if (!this.userId.equals(other.userId)) {
          return false;
        }
      } else {
        if (other.userId != null) {
          return false;
        }
      }
      this.ensureRoles();
      other.ensureRoles();
      
      if (this.roles != null) {
        if (!this.roles.equals(other.roles)) {
          return false;
        }
      } else {
        if (other.roles != null) {
          return false;
        }
      }
      this.ensureSubjectProperties();
      other.ensureSubjectProperties();
      
      if (this.subjectProperties != null) {
        if (!this.subjectProperties.equals(other.subjectProperties)) {
          return false;
        }
      } else {
        if (other.subjectProperties != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (subjectId != null ? subjectId.hashCode() : 0);
      hash = hash * 31 + (userName != null ? userName.hashCode() : 0);
      hash = hash * 31 + (scope != null ? scope.hashCode() : 0);
      hash = hash * 31 + (userId != null ? userId.hashCode() : 0);
      ensureRoles();
      hash = hash * 31 + (roles != null ? roles.hashCode() : 0);
      ensureSubjectProperties();
      hash = hash * 31 + (subjectProperties != null ? subjectProperties.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
      return toJsonElementInt(true);
    }
    public JsonElement toJsonElementInt(boolean copyJsons) {
      JsonObject result = new JsonObject();

      JsonElement subjectIdOut = (this.subjectId == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.subjectId);
      result.add("subjectId", subjectIdOut);

      JsonElement userNameOut = (this.userName == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.userName);
      result.add("userName", userNameOut);

      JsonElement scopeOut = (this.scope == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.scope);
      result.add("scope", scopeOut);

      JsonElement userIdOut = (this.userId == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.userId);
      result.add("userId", userIdOut);

      JsonArray rolesOut = new JsonArray();
      this.ensureRoles();
      for (java.lang.String roles_ : this.roles) {
        JsonElement rolesOut_ = (roles_ == null) ? JsonNull.INSTANCE : new JsonPrimitive(roles_);
        rolesOut.add(rolesOut_);
      }
      result.add("roles", rolesOut);

      JsonObject subjectPropertiesOut = new JsonObject();
      this.ensureSubjectProperties();
      for (java.util.Map.Entry<String, java.lang.String> entry0 : this.subjectProperties.entrySet()) {
        java.lang.String subjectProperties_ = entry0.getValue();
        JsonElement subjectPropertiesOut_ = (subjectProperties_ == null) ? JsonNull.INSTANCE : new JsonPrimitive(subjectProperties_);
        subjectPropertiesOut.add(entry0.getKey(), subjectPropertiesOut_);
      }
      result.add("subjectProperties", subjectPropertiesOut);
      return result;
    }

    @Override
    public String toJson() {
      return gson.toJson(toJsonElementInt(false));
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static MembershipDtoImpl fromJsonElement(JsonElement jsonElem) {
      return fromJsonElement(jsonElem, true);
    }
    public static MembershipDtoImpl fromJsonElement(JsonElement jsonElem, boolean copyJsons) {
      if (jsonElem == null || jsonElem.isJsonNull()) {
        return null;
      }

      MembershipDtoImpl dto = new MembershipDtoImpl();
      JsonObject json = jsonElem.getAsJsonObject();

      if (json.has("subjectId")) {
        JsonElement subjectIdIn = json.get("subjectId");
        java.lang.String subjectIdOut = gson.fromJson(subjectIdIn, java.lang.String.class);
        dto.setSubjectId(subjectIdOut);
      }

      if (json.has("userName")) {
        JsonElement userNameIn = json.get("userName");
        java.lang.String userNameOut = gson.fromJson(userNameIn, java.lang.String.class);
        dto.setUserName(userNameOut);
      }

      if (json.has("scope")) {
        JsonElement scopeIn = json.get("scope");
        java.lang.String scopeOut = gson.fromJson(scopeIn, java.lang.String.class);
        dto.setScope(scopeOut);
      }

      if (json.has("userId")) {
        JsonElement userIdIn = json.get("userId");
        java.lang.String userIdOut = gson.fromJson(userIdIn, java.lang.String.class);
        dto.setUserId(userIdOut);
      }

      if (json.has("roles")) {
        JsonElement rolesIn = json.get("roles");
        java.util.List<java.lang.String> rolesOut = null;
        if (rolesIn != null && !rolesIn.isJsonNull()) {
          rolesOut = new java.util.ArrayList<java.lang.String>();
          java.util.Iterator<JsonElement> rolesInIterator = rolesIn.getAsJsonArray().iterator();
          while (rolesInIterator.hasNext()) {
            JsonElement rolesIn_ = rolesInIterator.next();
            java.lang.String rolesOut_ = gson.fromJson(rolesIn_, java.lang.String.class);
            rolesOut.add(rolesOut_);
          }
        }
        dto.setRoles(rolesOut);
      }

      if (json.has("subjectProperties")) {
        JsonElement subjectPropertiesIn = json.get("subjectProperties");
        java.util.Map<java.lang.String, java.lang.String> subjectPropertiesOut = null;
        if (subjectPropertiesIn != null && !subjectPropertiesIn.isJsonNull()) {
          subjectPropertiesOut = new java.util.HashMap<java.lang.String, java.lang.String>();
          java.util.Set<java.util.Map.Entry<String, JsonElement>> entries0 = subjectPropertiesIn.getAsJsonObject().entrySet();
          for (java.util.Map.Entry<String, JsonElement> entry0 : entries0) {
            JsonElement subjectPropertiesIn_ = entry0.getValue();
            java.lang.String subjectPropertiesOut_ = gson.fromJson(subjectPropertiesIn_, java.lang.String.class);
            subjectPropertiesOut.put(entry0.getKey(), subjectPropertiesOut_);
          }
        }
        dto.setSubjectProperties(subjectPropertiesOut);
      }

      return dto;
    }

    public static MembershipDtoImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonElement(new JsonParser().parse(jsonString), false);
    }

    public MembershipDtoImpl(org.eclipse.che.api.user.shared.dto.MembershipDto origin) {
      this.subjectId = origin.getSubjectId();
      this.userName = origin.getUserName();
      this.scope = origin.getScope();
      this.userId = origin.getUserId();
      java.util.List<java.lang.String> rolesIn = origin.getRoles();
      if (rolesIn != null) {
        java.util.List<java.lang.String> rolesOut = new java.util.ArrayList<java.lang.String>();
        for (java.lang.String rolesIn_ : rolesIn) {
            rolesOut.add(rolesIn_);
        }
        this.roles = rolesOut;
      }
      java.util.Map<java.lang.String, java.lang.String> subjectPropertiesIn = origin.getSubjectProperties();
      if (subjectPropertiesIn != null) {
        java.util.Map<java.lang.String, java.lang.String> subjectPropertiesOut = new java.util.HashMap<java.lang.String, java.lang.String>();
        for (java.util.Map.Entry<String, java.lang.String> entry0 : subjectPropertiesIn.entrySet()) {
          java.lang.String subjectPropertiesIn_ = entry0.getValue();
            subjectPropertiesOut.put(entry0.getKey(), subjectPropertiesIn_);
        }
        this.subjectProperties = subjectPropertiesOut;
      }
    }

    public org.eclipse.che.api.user.shared.dto.MembershipDto withSubjectId(java.lang.String v) {
      this.subjectId = v;
      return this;
    }

    public org.eclipse.che.api.user.shared.dto.MembershipDto withUserName(java.lang.String v) {
      this.userName = v;
      return this;
    }

    public org.eclipse.che.api.user.shared.dto.MembershipDto withScope(java.lang.String v) {
      this.scope = v;
      return this;
    }

    public org.eclipse.che.api.user.shared.dto.MembershipDto withUserId(java.lang.String v) {
      this.userId = v;
      return this;
    }

    public org.eclipse.che.api.user.shared.dto.MembershipDto withRoles(java.util.List<java.lang.String> v) {
      this.roles = v;
      return this;
    }

    public org.eclipse.che.api.user.shared.dto.MembershipDto withSubjectProperties(java.util.Map<java.lang.String, java.lang.String> v) {
      this.subjectProperties = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class ProfileDescriptorImpl implements org.eclipse.che.api.user.shared.dto.ProfileDescriptor, JsonSerializable  {

    public static ProfileDescriptorImpl make() {
        return new ProfileDescriptorImpl();
    }

    public ProfileDescriptorImpl() {
    }

    protected java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> links;
    protected java.util.Map<java.lang.String, java.lang.String> attributes;
    protected java.lang.String id;
    protected java.lang.String userId;

    @Override
    public java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> getLinks() {
      ensureLinks();
      return new org.eclipse.che.dto.server.JsonArrayImpl(links);
    }

    public void setLinks(java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> v) {
      this.links = v;
    }

    public void addLinks(org.eclipse.che.api.core.rest.shared.dto.Link v) {
      ensureLinks();
      links.add(v);
    }

    public void clearLinks() {
      ensureLinks();
      links.clear();
    }

    protected void ensureLinks() {
      if (links == null) {
        links = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
      }
    }
    @Override
    public java.util.Map<java.lang.String, java.lang.String> getAttributes() {
      ensureAttributes();
      return new org.eclipse.che.dto.server.JsonStringMapImpl(attributes);
    }

    public void setAttributes(java.util.Map<java.lang.String, java.lang.String> v) {
      this.attributes = v;
    }

    public void putAttributes(String k, java.lang.String v) {
      ensureAttributes();
      attributes.put(k, v);
    }

    public void clearAttributes() {
      ensureAttributes();
      attributes.clear();
    }

    protected void ensureAttributes() {
      if (attributes == null) {
        attributes = new java.util.HashMap<java.lang.String, java.lang.String>();
      }
    }
    @Override
    public java.lang.String getId() {
      return id;
    }

    public void setId(java.lang.String v) {
      this.id = v;
    }

    @Override
    public java.lang.String getUserId() {
      return userId;
    }

    public void setUserId(java.lang.String v) {
      this.userId = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof ProfileDescriptorImpl)) {
        return false;
      }
      ProfileDescriptorImpl other = (ProfileDescriptorImpl) o;
      this.ensureLinks();
      other.ensureLinks();
      
      if (this.links != null) {
        if (!this.links.equals(other.links)) {
          return false;
        }
      } else {
        if (other.links != null) {
          return false;
        }
      }
      this.ensureAttributes();
      other.ensureAttributes();
      
      if (this.attributes != null) {
        if (!this.attributes.equals(other.attributes)) {
          return false;
        }
      } else {
        if (other.attributes != null) {
          return false;
        }
      }
      if (this.id != null) {
        if (!this.id.equals(other.id)) {
          return false;
        }
      } else {
        if (other.id != null) {
          return false;
        }
      }
      if (this.userId != null) {
        if (!this.userId.equals(other.userId)) {
          return false;
        }
      } else {
        if (other.userId != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      ensureLinks();
      hash = hash * 31 + (links != null ? links.hashCode() : 0);
      ensureAttributes();
      hash = hash * 31 + (attributes != null ? attributes.hashCode() : 0);
      hash = hash * 31 + (id != null ? id.hashCode() : 0);
      hash = hash * 31 + (userId != null ? userId.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
      return toJsonElementInt(true);
    }
    public JsonElement toJsonElementInt(boolean copyJsons) {
      JsonObject result = new JsonObject();

      JsonArray linksOut = new JsonArray();
      this.ensureLinks();
      for (org.eclipse.che.api.core.rest.shared.dto.Link links_ : this.links) {
        JsonElement linksOut_ = links_ == null ? JsonNull.INSTANCE : ((org.eclipse.che.api.core.server.dto.DtoServerImpls.LinkImpl)links_).toJsonElementInt(copyJsons);
        linksOut.add(linksOut_);
      }
      result.add("links", linksOut);

      JsonObject attributesOut = new JsonObject();
      this.ensureAttributes();
      for (java.util.Map.Entry<String, java.lang.String> entry0 : this.attributes.entrySet()) {
        java.lang.String attributes_ = entry0.getValue();
        JsonElement attributesOut_ = (attributes_ == null) ? JsonNull.INSTANCE : new JsonPrimitive(attributes_);
        attributesOut.add(entry0.getKey(), attributesOut_);
      }
      result.add("attributes", attributesOut);

      JsonElement idOut = (this.id == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.id);
      result.add("id", idOut);

      JsonElement userIdOut = (this.userId == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.userId);
      result.add("userId", userIdOut);
      return result;
    }

    @Override
    public String toJson() {
      return gson.toJson(toJsonElementInt(false));
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static ProfileDescriptorImpl fromJsonElement(JsonElement jsonElem) {
      return fromJsonElement(jsonElem, true);
    }
    public static ProfileDescriptorImpl fromJsonElement(JsonElement jsonElem, boolean copyJsons) {
      if (jsonElem == null || jsonElem.isJsonNull()) {
        return null;
      }

      ProfileDescriptorImpl dto = new ProfileDescriptorImpl();
      JsonObject json = jsonElem.getAsJsonObject();

      if (json.has("links")) {
        JsonElement linksIn = json.get("links");
        java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksOut = null;
        if (linksIn != null && !linksIn.isJsonNull()) {
          linksOut = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
          java.util.Iterator<JsonElement> linksInIterator = linksIn.getAsJsonArray().iterator();
          while (linksInIterator.hasNext()) {
            JsonElement linksIn_ = linksInIterator.next();
            org.eclipse.che.api.core.rest.shared.dto.Link linksOut_ = org.eclipse.che.api.core.server.dto.DtoServerImpls.LinkImpl.fromJsonElement(linksIn_, copyJsons);
            linksOut.add(linksOut_);
          }
        }
        dto.setLinks(linksOut);
      }

      if (json.has("attributes")) {
        JsonElement attributesIn = json.get("attributes");
        java.util.Map<java.lang.String, java.lang.String> attributesOut = null;
        if (attributesIn != null && !attributesIn.isJsonNull()) {
          attributesOut = new java.util.HashMap<java.lang.String, java.lang.String>();
          java.util.Set<java.util.Map.Entry<String, JsonElement>> entries0 = attributesIn.getAsJsonObject().entrySet();
          for (java.util.Map.Entry<String, JsonElement> entry0 : entries0) {
            JsonElement attributesIn_ = entry0.getValue();
            java.lang.String attributesOut_ = gson.fromJson(attributesIn_, java.lang.String.class);
            attributesOut.put(entry0.getKey(), attributesOut_);
          }
        }
        dto.setAttributes(attributesOut);
      }

      if (json.has("id")) {
        JsonElement idIn = json.get("id");
        java.lang.String idOut = gson.fromJson(idIn, java.lang.String.class);
        dto.setId(idOut);
      }

      if (json.has("userId")) {
        JsonElement userIdIn = json.get("userId");
        java.lang.String userIdOut = gson.fromJson(userIdIn, java.lang.String.class);
        dto.setUserId(userIdOut);
      }

      return dto;
    }

    public static ProfileDescriptorImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonElement(new JsonParser().parse(jsonString), false);
    }

    public ProfileDescriptorImpl(org.eclipse.che.api.user.shared.dto.ProfileDescriptor origin) {
      java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksIn = origin.getLinks();
      if (linksIn != null) {
        java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksOut = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
        for (org.eclipse.che.api.core.rest.shared.dto.Link linksIn_ : linksIn) {
            linksOut.add(linksIn_);
        }
        this.links = linksOut;
      }
      java.util.Map<java.lang.String, java.lang.String> attributesIn = origin.getAttributes();
      if (attributesIn != null) {
        java.util.Map<java.lang.String, java.lang.String> attributesOut = new java.util.HashMap<java.lang.String, java.lang.String>();
        for (java.util.Map.Entry<String, java.lang.String> entry0 : attributesIn.entrySet()) {
          java.lang.String attributesIn_ = entry0.getValue();
            attributesOut.put(entry0.getKey(), attributesIn_);
        }
        this.attributes = attributesOut;
      }
      this.id = origin.getId();
      this.userId = origin.getUserId();
    }

    public org.eclipse.che.api.user.shared.dto.ProfileDescriptor withLinks(java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> v) {
      this.links = v;
      return this;
    }

    public org.eclipse.che.api.user.shared.dto.ProfileDescriptor withAttributes(java.util.Map<java.lang.String, java.lang.String> v) {
      this.attributes = v;
      return this;
    }

    public org.eclipse.che.api.user.shared.dto.ProfileDescriptor withId(java.lang.String v) {
      this.id = v;
      return this;
    }

    public org.eclipse.che.api.user.shared.dto.ProfileDescriptor withUserId(java.lang.String v) {
      this.userId = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class UserDescriptorImpl implements org.eclipse.che.api.user.shared.dto.UserDescriptor, JsonSerializable  {

    public static UserDescriptorImpl make() {
        return new UserDescriptorImpl();
    }

    public UserDescriptorImpl() {
    }

    protected java.lang.String password;
    protected java.util.List<java.lang.String> aliases;
    protected java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> links;
    protected java.lang.String name;
    protected java.lang.String email;
    protected java.lang.String id;

    @Override
    public java.lang.String getPassword() {
      return password;
    }

    public void setPassword(java.lang.String v) {
      this.password = v;
    }

    @Override
    public java.util.List<java.lang.String> getAliases() {
      ensureAliases();
      return new org.eclipse.che.dto.server.JsonArrayImpl(aliases);
    }

    public void setAliases(java.util.List<java.lang.String> v) {
      this.aliases = v;
    }

    public void addAliases(java.lang.String v) {
      ensureAliases();
      aliases.add(v);
    }

    public void clearAliases() {
      ensureAliases();
      aliases.clear();
    }

    protected void ensureAliases() {
      if (aliases == null) {
        aliases = new java.util.ArrayList<java.lang.String>();
      }
    }
    @Override
    public java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> getLinks() {
      ensureLinks();
      return new org.eclipse.che.dto.server.JsonArrayImpl(links);
    }

    public void setLinks(java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> v) {
      this.links = v;
    }

    public void addLinks(org.eclipse.che.api.core.rest.shared.dto.Link v) {
      ensureLinks();
      links.add(v);
    }

    public void clearLinks() {
      ensureLinks();
      links.clear();
    }

    protected void ensureLinks() {
      if (links == null) {
        links = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
      }
    }
    @Override
    public java.lang.String getName() {
      return name;
    }

    public void setName(java.lang.String v) {
      this.name = v;
    }

    @Override
    public java.lang.String getEmail() {
      return email;
    }

    public void setEmail(java.lang.String v) {
      this.email = v;
    }

    @Override
    public java.lang.String getId() {
      return id;
    }

    public void setId(java.lang.String v) {
      this.id = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof UserDescriptorImpl)) {
        return false;
      }
      UserDescriptorImpl other = (UserDescriptorImpl) o;
      if (this.password != null) {
        if (!this.password.equals(other.password)) {
          return false;
        }
      } else {
        if (other.password != null) {
          return false;
        }
      }
      this.ensureAliases();
      other.ensureAliases();
      
      if (this.aliases != null) {
        if (!this.aliases.equals(other.aliases)) {
          return false;
        }
      } else {
        if (other.aliases != null) {
          return false;
        }
      }
      this.ensureLinks();
      other.ensureLinks();
      
      if (this.links != null) {
        if (!this.links.equals(other.links)) {
          return false;
        }
      } else {
        if (other.links != null) {
          return false;
        }
      }
      if (this.name != null) {
        if (!this.name.equals(other.name)) {
          return false;
        }
      } else {
        if (other.name != null) {
          return false;
        }
      }
      if (this.email != null) {
        if (!this.email.equals(other.email)) {
          return false;
        }
      } else {
        if (other.email != null) {
          return false;
        }
      }
      if (this.id != null) {
        if (!this.id.equals(other.id)) {
          return false;
        }
      } else {
        if (other.id != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (password != null ? password.hashCode() : 0);
      ensureAliases();
      hash = hash * 31 + (aliases != null ? aliases.hashCode() : 0);
      ensureLinks();
      hash = hash * 31 + (links != null ? links.hashCode() : 0);
      hash = hash * 31 + (name != null ? name.hashCode() : 0);
      hash = hash * 31 + (email != null ? email.hashCode() : 0);
      hash = hash * 31 + (id != null ? id.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
      return toJsonElementInt(true);
    }
    public JsonElement toJsonElementInt(boolean copyJsons) {
      JsonObject result = new JsonObject();

      JsonElement passwordOut = (this.password == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.password);
      result.add("password", passwordOut);

      JsonArray aliasesOut = new JsonArray();
      this.ensureAliases();
      for (java.lang.String aliases_ : this.aliases) {
        JsonElement aliasesOut_ = (aliases_ == null) ? JsonNull.INSTANCE : new JsonPrimitive(aliases_);
        aliasesOut.add(aliasesOut_);
      }
      result.add("aliases", aliasesOut);

      JsonArray linksOut = new JsonArray();
      this.ensureLinks();
      for (org.eclipse.che.api.core.rest.shared.dto.Link links_ : this.links) {
        JsonElement linksOut_ = links_ == null ? JsonNull.INSTANCE : ((org.eclipse.che.api.core.server.dto.DtoServerImpls.LinkImpl)links_).toJsonElementInt(copyJsons);
        linksOut.add(linksOut_);
      }
      result.add("links", linksOut);

      JsonElement nameOut = (this.name == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.name);
      result.add("name", nameOut);

      JsonElement emailOut = (this.email == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.email);
      result.add("email", emailOut);

      JsonElement idOut = (this.id == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.id);
      result.add("id", idOut);
      return result;
    }

    @Override
    public String toJson() {
      return gson.toJson(toJsonElementInt(false));
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static UserDescriptorImpl fromJsonElement(JsonElement jsonElem) {
      return fromJsonElement(jsonElem, true);
    }
    public static UserDescriptorImpl fromJsonElement(JsonElement jsonElem, boolean copyJsons) {
      if (jsonElem == null || jsonElem.isJsonNull()) {
        return null;
      }

      UserDescriptorImpl dto = new UserDescriptorImpl();
      JsonObject json = jsonElem.getAsJsonObject();

      if (json.has("password")) {
        JsonElement passwordIn = json.get("password");
        java.lang.String passwordOut = gson.fromJson(passwordIn, java.lang.String.class);
        dto.setPassword(passwordOut);
      }

      if (json.has("aliases")) {
        JsonElement aliasesIn = json.get("aliases");
        java.util.List<java.lang.String> aliasesOut = null;
        if (aliasesIn != null && !aliasesIn.isJsonNull()) {
          aliasesOut = new java.util.ArrayList<java.lang.String>();
          java.util.Iterator<JsonElement> aliasesInIterator = aliasesIn.getAsJsonArray().iterator();
          while (aliasesInIterator.hasNext()) {
            JsonElement aliasesIn_ = aliasesInIterator.next();
            java.lang.String aliasesOut_ = gson.fromJson(aliasesIn_, java.lang.String.class);
            aliasesOut.add(aliasesOut_);
          }
        }
        dto.setAliases(aliasesOut);
      }

      if (json.has("links")) {
        JsonElement linksIn = json.get("links");
        java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksOut = null;
        if (linksIn != null && !linksIn.isJsonNull()) {
          linksOut = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
          java.util.Iterator<JsonElement> linksInIterator = linksIn.getAsJsonArray().iterator();
          while (linksInIterator.hasNext()) {
            JsonElement linksIn_ = linksInIterator.next();
            org.eclipse.che.api.core.rest.shared.dto.Link linksOut_ = org.eclipse.che.api.core.server.dto.DtoServerImpls.LinkImpl.fromJsonElement(linksIn_, copyJsons);
            linksOut.add(linksOut_);
          }
        }
        dto.setLinks(linksOut);
      }

      if (json.has("name")) {
        JsonElement nameIn = json.get("name");
        java.lang.String nameOut = gson.fromJson(nameIn, java.lang.String.class);
        dto.setName(nameOut);
      }

      if (json.has("email")) {
        JsonElement emailIn = json.get("email");
        java.lang.String emailOut = gson.fromJson(emailIn, java.lang.String.class);
        dto.setEmail(emailOut);
      }

      if (json.has("id")) {
        JsonElement idIn = json.get("id");
        java.lang.String idOut = gson.fromJson(idIn, java.lang.String.class);
        dto.setId(idOut);
      }

      return dto;
    }

    public static UserDescriptorImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonElement(new JsonParser().parse(jsonString), false);
    }

    public UserDescriptorImpl(org.eclipse.che.api.user.shared.dto.UserDescriptor origin) {
      this.password = origin.getPassword();
      java.util.List<java.lang.String> aliasesIn = origin.getAliases();
      if (aliasesIn != null) {
        java.util.List<java.lang.String> aliasesOut = new java.util.ArrayList<java.lang.String>();
        for (java.lang.String aliasesIn_ : aliasesIn) {
            aliasesOut.add(aliasesIn_);
        }
        this.aliases = aliasesOut;
      }
      java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksIn = origin.getLinks();
      if (linksIn != null) {
        java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksOut = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
        for (org.eclipse.che.api.core.rest.shared.dto.Link linksIn_ : linksIn) {
            linksOut.add(linksIn_);
        }
        this.links = linksOut;
      }
      this.name = origin.getName();
      this.email = origin.getEmail();
      this.id = origin.getId();
    }

    public org.eclipse.che.api.user.shared.dto.UserDescriptor withPassword(java.lang.String v) {
      this.password = v;
      return this;
    }

    public org.eclipse.che.api.user.shared.dto.UserDescriptor withAliases(java.util.List<java.lang.String> v) {
      this.aliases = v;
      return this;
    }

    public org.eclipse.che.api.user.shared.dto.UserDescriptor withLinks(java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> v) {
      this.links = v;
      return this;
    }

    public org.eclipse.che.api.user.shared.dto.UserDescriptor withName(java.lang.String v) {
      this.name = v;
      return this;
    }

    public org.eclipse.che.api.user.shared.dto.UserDescriptor withEmail(java.lang.String v) {
      this.email = v;
      return this;
    }

    public org.eclipse.che.api.user.shared.dto.UserDescriptor withId(java.lang.String v) {
      this.id = v;
      return this;
    }

  }


}