/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class EnableDisableInjectMetricsAction
implements IObjectActionDelegate {
    protected CodewindEclipseApplication app;

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        if (!(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindEclipseApplication) {
            this.app = (CodewindEclipseApplication)obj;
            if (this.app.isAvailable() && this.app.canInjectMetrics()) {
                if (this.app.isInjectMetrics()) {
                    action.setText(Messages.DisableInjectMetricsLabel);
                } else {
                    action.setText(Messages.EnableInjectMetricsLabel);
                }
                action.setEnabled(true);
                return;
            }
        }
        action.setEnabled(false);
    }

    public void run(IAction action) {
        if (this.app == null) {
            Logger.logError((String)(Messages.ErrorOnEnableDisableInjectMetrics + " ran but no application was selected"));
            return;
        }
        EnableDisableInjectMetricsAction.enableDisableInjectMetrics((CodewindApplication)this.app, !this.app.isInjectMetrics());
    }

    public static void enableDisableInjectMetrics(final CodewindApplication app, final boolean enable) {
        Job job = new Job(NLS.bind((String)Messages.EnableDisableInjectMetricsJob, (Object)app.name)){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    app.connection.requestInjectMetrics(app.projectID, enable);
                    app.setInjectMetrics(enable);
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    Logger.logError((String)("An error occurred changing inject metric setting for: " + app.name + ", with id: " + app.projectID), (Throwable)e);
                    return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.ErrorOnEnableDisableInjectMetrics, (Object)app.name), (Throwable)e);
                }
            }
        };
        job.schedule();
    }

    public void setActivePart(IAction arg0, IWorkbenchPart arg1) {
    }
}

